/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.utils;

import ch.tachyon.tunnel.engine.utils.FloatQueue;

public class McRebufferizer {
    private final FloatQueue[] inBuffers;
    private final FloatQueue[] outBuffers;
    private final float[][] output;
    private final int targetChunkSize;

    public McRebufferizer(int nbChans, int maxInputSize, int targetOutputSize) {
        this.targetChunkSize = targetOutputSize;
        this.inBuffers = new FloatQueue[nbChans];
        int i = 0;
        while (i < nbChans) {
            this.inBuffers[i] = new FloatQueue(maxInputSize + targetOutputSize);
            ++i;
        }
        this.output = new float[nbChans][targetOutputSize];
        this.outBuffers = new FloatQueue[nbChans];
        i = 0;
        while (i < nbChans) {
            this.outBuffers[i] = new FloatQueue(targetOutputSize, maxInputSize + targetOutputSize);
            ++i;
        }
    }

    public void submitVariable(float[][] input) {
        int i = 0;
        while (i < input.length) {
            this.inBuffers[i].pushArray(input[i]);
            ++i;
        }
    }

    public float[][] retrieveFixed() {
        if (this.inBuffers[0].getSize() >= this.targetChunkSize) {
            int i = 0;
            while (i < this.inBuffers.length) {
                this.inBuffers[i].popArray(this.output[i]);
                ++i;
            }
            return this.output;
        }
        return null;
    }

    public void submitFixed(float[][] input) {
        int i = 0;
        while (i < input.length) {
            this.outBuffers[i].pushArray(input[i]);
            ++i;
        }
    }

    public void retrieveVariable(float[][] target) {
        int i = 0;
        while (i < target.length) {
            this.outBuffers[i].popArray(target[i]);
            ++i;
        }
    }

    public int getLatency() {
        return this.targetChunkSize;
    }

    public int getTargetSize() {
        return this.targetChunkSize;
    }
}

