/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.utils;

import ch.tachyon.tunnel.engine.utils.FloatQueue;

public class Rebufferizer {
    private final FloatQueue inBuffer;
    private final FloatQueue outBuffer;
    private final float[] output;
    private final int targetChunkSize;

    public Rebufferizer(int maxInputSize, int targetOutputSize) {
        this.targetChunkSize = targetOutputSize;
        this.inBuffer = new FloatQueue(maxInputSize + targetOutputSize);
        this.output = new float[targetOutputSize];
        this.outBuffer = new FloatQueue(targetOutputSize, maxInputSize + targetOutputSize);
    }

    public void submitVariable(float[] input) {
        this.inBuffer.pushArray(input);
    }

    public float[] retrieveFixed() {
        if (this.inBuffer.getSize() >= this.targetChunkSize) {
            this.inBuffer.popArray(this.output);
            return this.output;
        }
        return null;
    }

    public void submitFixed(float[] input) {
        this.outBuffer.pushArray(input);
    }

    public void retrieveVariable(float[] target) {
        this.outBuffer.popArray(target);
    }

    public int getLatency() {
        return this.targetChunkSize;
    }

    public int getTargetSize() {
        return this.targetChunkSize;
    }

    public String toString() {
        return "Rebufferizer [0.." + (this.inBuffer.getCapacity() - this.targetChunkSize) + " -> " + this.targetChunkSize + "]";
    }
}

