/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.utils.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberInfo {
    private final String name;
    private final Method reader;
    private final Method writer;

    MemberInfo(String name, Method reader, Method writer) {
        this.name = name;
        this.reader = reader;
        this.writer = writer;
    }

    public MemberInfo(Class<?> type, String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Specified name is empty or null");
        }
        String uName = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        try {
            Method readMethod;
            this.name = name;
            try {
                readMethod = type.getMethod("get" + uName, new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                readMethod = type.getMethod("is" + uName, new Class[0]);
            }
            this.reader = readMethod;
            this.writer = type.getMethod("set" + uName, this.reader.getReturnType());
        }
        catch (NoSuchMethodException ex2) {
            throw new IllegalArgumentException("Property not found: " + name);
        }
    }

    public Class<?> getType() {
        return this.reader.getReturnType();
    }

    public Method getReader() {
        return this.reader;
    }

    public Method getWriter() {
        return this.writer;
    }

    public Object getValue(Object instance) throws InvocationTargetException {
        try {
            return this.reader.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessError(ex.getMessage());
        }
    }

    public void setValue(Object instance, Object value) throws InvocationTargetException {
        try {
            this.writer.invoke(instance, value);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessError(ex.getMessage());
        }
    }

    public String getName() {
        return this.name;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (this.reader != null) {
            return this.reader.getAnnotation(annotationClass);
        }
        return this.writer.getAnnotation(annotationClass);
    }

    public Annotation[] getAnnotations() {
        if (this.reader != null) {
            return this.reader.getAnnotations();
        }
        return this.writer.getAnnotations();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MemberInfo) {
            MemberInfo other = (MemberInfo)obj;
            return this.name.equals(other.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

