/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.utils.concurrent;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentLinkedBlockingQueue<E> {
    private final int capacity;
    private final ConcurrentLinkedQueue<E> target = new ConcurrentLinkedQueue();
    private final Lock lock;
    private final Condition notFull;
    private final Condition notEmpty;
    private final AtomicInteger size = new AtomicInteger();
    private final AtomicInteger notFullWaiters = new AtomicInteger();
    private final AtomicInteger notEmptyWaiters = new AtomicInteger();

    public ConcurrentLinkedBlockingQueue(int capacity, boolean fair) {
        this.capacity = capacity;
        this.lock = new ReentrantLock(fair);
        this.notFull = this.lock.newCondition();
        this.notEmpty = this.lock.newCondition();
    }

    public E poll() {
        E result = this.target.poll();
        if (result == null) {
            return null;
        }
        this.size.decrementAndGet();
        if (this.notFullWaiters.get() > 0) {
            this.lock.lock();
            try {
                this.notFull.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
        return result;
    }

    public E take() throws InterruptedException {
        E result = this.poll();
        if (result != null) {
            return result;
        }
        this.notEmptyWaiters.incrementAndGet();
        try {
            this.lock.lock();
            result = this.poll();
            while (result == null) {
                this.notEmpty.await();
                result = this.poll();
            }
        }
        finally {
            this.lock.unlock();
        }
        this.notEmptyWaiters.decrementAndGet();
        return result;
    }

    public boolean offer(E element) {
        int newSize = this.size.incrementAndGet();
        if (newSize > this.capacity) {
            this.size.decrementAndGet();
            return false;
        }
        boolean result = this.target.offer(element);
        assert (result);
        if (this.notEmptyWaiters.get() > 0) {
            this.lock.lock();
            try {
                this.notEmpty.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
        return result;
    }

    public void put(E element) throws InterruptedException {
        boolean result = this.offer(element);
        if (result) {
            return;
        }
        this.notFullWaiters.incrementAndGet();
        try {
            this.lock.lock();
            result = this.offer(element);
            while (!result) {
                this.notFull.await();
                result = this.offer(element);
            }
        }
        finally {
            this.lock.unlock();
        }
        this.notFullWaiters.decrementAndGet();
    }

    public int size() {
        return this.size.get();
    }

    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    public void clear() {
        this.target.clear();
        if (this.notFullWaiters.get() > 0) {
            this.lock.lock();
            try {
                this.notFull.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

