/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.utils.concurrent;

import ch.tachyon.tunnel.engine.utils.concurrent.ConcurrentLinkedBlockingQueue;
import ch.tachyon.tunnel.engine.utils.concurrent.Task;
import ch.tachyon.tunnel.utils.Debug;
import ch.tachyon.tunnel.utils.Monitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPool {
    private int poolSize;
    private int queueSize;
    private ConcurrentLinkedBlockingQueue<Task> taskQueue;
    private Object queueLock = new Monitor("ThreadPool.lock");
    private Thread[] poolThreads;
    private volatile boolean active = true;
    private List<TaskFactory> taskFactories;
    private ThreadLocal<TaskFactory> curFactory = new ThreadLocal();
    private List<Queue<Task>> executeByEachQueue;

    public ThreadPool(String name) {
        this(name, -1);
    }

    public ThreadPool(String name, int nbThreads) {
        if (nbThreads <= 0) {
            nbThreads = Runtime.getRuntime().availableProcessors();
        }
        this.poolSize = nbThreads > 1 ? nbThreads : 0;
        this.queueSize = ThreadPool.getDefaultQueueSize(nbThreads);
        this.taskQueue = new ConcurrentLinkedBlockingQueue(this.queueSize, false);
        this.executeByEachQueue = new ArrayList<Queue<Task>>(this.poolSize);
        int i = 0;
        while (i < this.poolSize) {
            this.executeByEachQueue.add(new ConcurrentLinkedQueue());
            ++i;
        }
        this.poolThreads = new Thread[this.poolSize];
        i = 0;
        while (i < this.poolThreads.length) {
            PoolThread t = new PoolThread(i, this);
            this.poolThreads[i] = t;
            t.setName(String.valueOf(name) + " Thread " + i);
            t.start();
            ++i;
        }
    }

    public static int getDefaultQueueSize(int nbThreads) {
        return nbThreads + 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskFactory(Task task) {
        if (!this.isMultiCore()) {
            throw new IllegalStateException("Task factories are not supported when only one CPU core is used");
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (this.taskFactories == null) {
                this.taskFactories = new CopyOnWriteArrayList<TaskFactory>();
            }
            this.taskFactories.add(new TaskFactory(task));
        }
        this.processFactories();
    }

    public synchronized boolean removeTaskFactory(Task task) {
        if (this.taskFactories == null) {
            return false;
        }
        boolean result = this.taskFactories.remove(new TaskFactory(task));
        if (this.taskFactories.isEmpty()) {
            this.taskFactories = null;
        }
        return result;
    }

    public synchronized void removeSelfTaskFactory() {
        if (this.taskFactories == null) {
            return;
        }
        TaskFactory factory = this.curFactory.get();
        if (factory == null) {
            throw new IllegalStateException("Not running a task factory");
        }
        this.taskFactories.remove(factory);
        if (this.taskFactories.isEmpty()) {
            this.taskFactories = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTask(int index, boolean wait) {
        this.processFactories();
        Task task = this.pollTask(index);
        if (task == null) {
            if (wait) {
                Object object = this.queueLock;
                synchronized (object) {
                    task = this.pollTask(index);
                    while (task == null) {
                        try {
                            this.queueLock.wait();
                        }
                        catch (InterruptedException ex) {
                            if (!this.active) {
                                return;
                            }
                            ex.printStackTrace();
                        }
                        task = this.pollTask(index);
                    }
                }
            }
            return;
        }
        try {
            task.run();
        }
        finally {
            task.setTerminated();
        }
    }

    private Task pollTask(int index) {
        Task result = this.pollExecuteByEach(index);
        if (result != null) {
            return result;
        }
        return this.taskQueue.poll();
    }

    private void processFactories() {
        List<TaskFactory> factories = this.taskFactories;
        if (factories != null) {
            int taskQueueSize = this.taskQueue.size();
            while (factories != null && (taskQueueSize == 0 || taskQueueSize < this.queueSize - factories.size())) {
                for (TaskFactory factory : factories) {
                    if (!factory.used.compareAndSet(false, true)) continue;
                    this.curFactory.set(factory);
                    factory.task.run();
                    this.curFactory.remove();
                    boolean success = factory.used.compareAndSet(true, false);
                    assert (success);
                    if (++taskQueueSize >= this.queueSize) break;
                }
                taskQueueSize = this.taskQueue.size();
                factories = this.taskFactories;
            }
        }
    }

    private Task pollExecuteByEach(int index) {
        Queue<Task> eachTasks = this.executeByEachQueue.get(index);
        return eachTasks.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Task task) {
        boolean nested;
        Thread t = Thread.currentThread();
        boolean bl = nested = t instanceof PoolThread && ((PoolThread)t).pool == this;
        if (nested) {
            PoolThread pt = (PoolThread)t;
            while (!this.offerTask(task)) {
                this.processTask(pt.index, false);
            }
        } else {
            try {
                this.taskQueue.put(task);
                Object pt = this.queueLock;
                synchronized (pt) {
                    this.queueLock.notify();
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean offerTask(Task task) {
        boolean result = this.taskQueue.offer(task);
        if (!result) {
            return false;
        }
        Object object = this.queueLock;
        synchronized (object) {
            this.queueLock.notify();
        }
        return true;
    }

    public void executeAndWait(Task ... tasks) {
        if (this.poolSize <= 1) {
            Task[] taskArray = tasks;
            int n = tasks.length;
            int n2 = 0;
            while (n2 < n) {
                Task task = taskArray[n2];
                task.run();
                ++n2;
            }
        } else {
            CountDownLatch latch = new CountDownLatch(tasks.length);
            Task[] taskArray = tasks;
            int n = tasks.length;
            int n3 = 0;
            while (n3 < n) {
                Task task = taskArray[n3];
                task.setLatch(latch);
                this.execute(task);
                ++n3;
            }
            this.waitFor(latch);
        }
    }

    public CountDownLatch submit(Task ... tasks) {
        if (this.poolSize <= 1) {
            Task[] taskArray = tasks;
            int n = tasks.length;
            int n2 = 0;
            while (n2 < n) {
                Task task = taskArray[n2];
                task.run();
                ++n2;
            }
            return null;
        }
        CountDownLatch latch = new CountDownLatch(tasks.length);
        Task[] taskArray = tasks;
        int n = tasks.length;
        int n3 = 0;
        while (n3 < n) {
            Task task = taskArray[n3];
            task.setLatch(latch);
            this.execute(task);
            ++n3;
        }
        return latch;
    }

    public void submitAsync(Task task) {
        if (this.poolSize <= 1) {
            task.run();
        } else {
            this.execute(task);
        }
    }

    public void submitFragment(Task task) {
        this.submitAsync(task);
    }

    public void waitFor(CountDownLatch latch) {
        if (latch == null) {
            return;
        }
        Thread t = Thread.currentThread();
        boolean nested = t instanceof PoolThread && ((PoolThread)t).pool == this;
        try {
            if (nested) {
                PoolThread pt = (PoolThread)t;
                while (!latch.await(0L, TimeUnit.NANOSECONDS)) {
                    this.processTask(pt.index, false);
                }
            } else {
                latch.await();
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void waitForCurrentlyQueuedTasks() {
        final CountDownLatch latch = new CountDownLatch(1);
        Task end = new Task(){

            public void run() {
                latch.countDown();
            }
        };
        this.submitAsync(end);
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public int getPoolSize() {
        return Math.max(1, this.poolSize);
    }

    public boolean isMultiCore() {
        return this.poolSize > 1;
    }

    public int getIncommingQueueCapacity() {
        return this.queueSize;
    }

    public int getQueueSize() {
        return this.taskQueue.size();
    }

    public boolean isFull() {
        return this.taskQueue.size() >= this.queueSize;
    }

    public Set<Thread> getPoolThreads() {
        if (this.poolSize == 0) {
            return Collections.singleton(Thread.currentThread());
        }
        return new HashSet<Thread>(Arrays.asList(this.poolThreads));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeByEachThread(final Runnable runnable) {
        if (this.poolSize <= 1) {
            runnable.run();
            return;
        }
        CountDownLatch finishLatch = new CountDownLatch(this.poolSize);
        Task task = new Task(){

            public void run() {
                runnable.run();
            }
        };
        task.setLatch(finishLatch);
        int i22 = 0;
        while (i22 < this.poolSize) {
            this.executeByEachQueue.get(i22).add(task);
            ++i22;
        }
        Object i22 = this.queueLock;
        synchronized (i22) {
            this.queueLock.notifyAll();
        }
        try {
            finishLatch.await();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeByEachThread(Task[] tasks) {
        if (tasks.length != Math.max(1, this.poolSize)) {
            throw new IllegalArgumentException();
        }
        if (this.poolSize <= 1) {
            tasks[0].run();
            return;
        }
        CountDownLatch finishLatch = new CountDownLatch(this.poolSize);
        int i22 = 0;
        while (i22 < this.poolSize) {
            tasks[i22].setLatch(finishLatch);
            this.executeByEachQueue.get(i22).add(tasks[i22]);
            ++i22;
        }
        Object i22 = this.queueLock;
        synchronized (i22) {
            this.queueLock.notifyAll();
        }
        try {
            finishLatch.await();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void dispose() {
        this.active = false;
        if (this.poolThreads != null) {
            Thread[] threadArray = this.poolThreads;
            int n = this.poolThreads.length;
            int n2 = 0;
            while (n2 < n) {
                Thread t = threadArray[n2];
                t.interrupt();
                try {
                    t.join(3000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                if (t.isAlive()) {
                    Debug.warn("Failed to stop pool thread " + t.getName(), new Object[0]);
                }
                ++n2;
            }
        }
        this.poolThreads = null;
        this.taskQueue = null;
        this.executeByEachQueue = null;
    }

    class PoolThread
    extends Thread {
        final int index;
        final ThreadPool pool;

        public PoolThread(int index, ThreadPool pool) {
            this.index = index;
            this.pool = pool;
        }

        public void run() {
            while (ThreadPool.this.active) {
                ThreadPool.this.processTask(this.index, true);
            }
        }
    }

    static class TaskFactory {
        public final Task task;
        public final AtomicBoolean used = new AtomicBoolean(false);

        public TaskFactory(Task task) {
            this.task = task;
        }

        public int hashCode() {
            return this.task.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            TaskFactory other = (TaskFactory)obj;
            return this.task.equals(other.task);
        }
    }
}

