/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.host;

import ch.tachyon.tunnel.common.IMultiChanAudioSink;
import java.util.ArrayList;
import java.util.List;

public class MultiChanArraySink
implements IMultiChanAudioSink {
    private final List<float[][]> data = new ArrayList<float[][]>();
    private int nbChannels;
    private int length;

    public void writeSamples(float[][] samples) {
        if (this.nbChannels == 0) {
            this.nbChannels = samples.length;
        } else if (this.nbChannels != samples.length) {
            throw new IllegalArgumentException("The written samples do not have the same number of channels");
        }
        int nbFrames = 0;
        int chan = 0;
        while (chan < this.nbChannels) {
            if (chan == 0) {
                nbFrames = samples[0].length;
            } else if (nbFrames != samples[chan].length) {
                throw new IllegalArgumentException("The array does not have the same number of samples in all channels");
            }
            ++chan;
        }
        this.data.add(samples);
        this.length += samples[0].length;
    }

    public float[][] toArray() {
        if (this.length == 0) {
            return new float[1][0];
        }
        float[][] result = new float[this.nbChannels][this.length];
        int offset = 0;
        for (float[][] block : this.data) {
            int chan = 0;
            while (chan < this.nbChannels) {
                System.arraycopy(block[chan], 0, result[chan], offset, block[chan].length);
                ++chan;
            }
            offset += block[0].length;
        }
        return result;
    }
}

