/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.plugin.param;

import ch.tachyon.tunnel.plugin.IPlugin;
import ch.tachyon.tunnel.plugin.param.Range;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParameterInfo<P extends IPlugin>
implements Cloneable,
Serializable {
    private Class<P> pluginType;
    private String javaName;
    private String displayName;
    private Class<?> type;
    private boolean out;
    private Collection<Annotation> annotations;

    public ParameterInfo() {
    }

    public ParameterInfo(Class<P> pluginType, String javaName, String displayName, Class<?> type) {
        this.pluginType = pluginType;
        this.javaName = javaName;
        this.displayName = displayName;
        this.type = type;
    }

    public ParameterInfo(Class<P> pluginType, String javaName, String displayName, Class<?> type, boolean out, Collection<Annotation> annotations) {
        this.pluginType = pluginType;
        this.javaName = javaName;
        this.displayName = displayName;
        this.type = type;
        this.out = out;
        this.annotations = annotations;
    }

    public Class<P> getPluginType() {
        return this.pluginType;
    }

    public void setPluginType(Class<P> pluginType) {
        this.pluginType = pluginType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public boolean isOut() {
        return this.out;
    }

    public void setOut(boolean out) {
        this.out = out;
    }

    public Collection<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Collection<Annotation> annotations) {
        this.annotations = annotations;
    }

    public <E extends Annotation> E getAnnotation(Class<E> type) {
        if (this.annotations == null) {
            return null;
        }
        for (Annotation anno : this.annotations) {
            if (!type.isInstance(anno)) continue;
            Annotation result = anno;
            return (E)result;
        }
        if (type.equals(Range.class)) {
            Range result = new Range(){

                @Override
                public Class<? extends Annotation> annotationType() {
                    return Range.class;
                }

                @Override
                public double minValue() {
                    return 0.0;
                }

                @Override
                public double maxValue() {
                    return 1.0;
                }

                @Override
                public double defaultValue() {
                    return 0.0;
                }
            };
            return (E)result;
        }
        return null;
    }

    public abstract Object getValue(P var1);

    public abstract void setValue(P var1, Object var2);

    public abstract Object getInternalValue(P var1);

    public abstract void setInternalValue(P var1, Object var2);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotations == null ? 0 : this.annotations.hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.pluginType == null ? 0 : this.pluginType.hashCode());
        result = 31 * result + (this.out ? 1231 : 1237);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterInfo other = (ParameterInfo)obj;
        if (this.annotations == null ? other.annotations != null : !this.annotations.equals(other.annotations)) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.pluginType == null ? other.pluginType != null : !this.pluginType.equals(other.pluginType)) {
            return false;
        }
        if (this.out != other.out) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public ParameterInfo<P> clone() {
        try {
            return (ParameterInfo)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }
}

