/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.plugin.param;

import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.param.IParameterTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerOfTwoTransform
implements IParameterTransform {
    private static final double LOG2 = Math.log(2.0);

    @Override
    public <E extends Number> E transform(E value, IProcessingInfo info) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (E)Long.valueOf(1L << (int)value.longValue());
        }
        if (value instanceof Integer) {
            return (E)Integer.valueOf(1 << value.intValue());
        }
        if (value instanceof Float) {
            return (E)Float.valueOf((float)Math.pow(2.0, value.floatValue()));
        }
        if (value instanceof Double) {
            return (E)Double.valueOf(Math.pow(2.0, value.doubleValue()));
        }
        throw new UnsupportedOperationException("Number class not supported: " + value.getClass());
    }

    @Override
    public <E extends Number> E untransform(E value, IProcessingInfo info) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (E)Long.valueOf(PowerOfTwoTransform.log2(value.longValue()));
        }
        if (value instanceof Integer) {
            return (E)Integer.valueOf((int)PowerOfTwoTransform.log2(value.longValue()));
        }
        if (value instanceof Float) {
            return (E)Float.valueOf((float)(Math.log(value.doubleValue()) / LOG2));
        }
        if (value instanceof Double) {
            return (E)Double.valueOf(Math.log(value.doubleValue()) / LOG2);
        }
        throw new UnsupportedOperationException("Number class not supported: " + value.getClass());
    }

    private static long log2(long value) {
        value = value * 141L / 100L;
        int log = 0;
        if (value >= 0x100000000L) {
            log += 32;
            value >>>= 32;
        }
        if (value >= 65536L) {
            log += 16;
            value >>>= 16;
        }
        if (value >= 256L) {
            log += 8;
            value >>>= 8;
        }
        if (value >= 16L) {
            log += 4;
            value >>>= 4;
        }
        if (value >= 4L) {
            log += 2;
            value >>>= 2;
        }
        if (value >= 2L) {
            ++log;
        }
        return log;
    }
}

