/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.audio.file;

import ch.tachyon.tunnel.utils.Debug;
import ch.tachyon.tunnel.utils.Monitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import org.corebounce.common.io.IOUtils;
import org.corebounce.common.io.RandomFileInputStream;
import org.corebounce.common.utils.StringUtils;
import org.tritonus.sampled.file.AiffAudioFileWriter;
import org.tritonus.sampled.file.AuAudioFileWriter;
import org.tritonus.sampled.file.WaveAudioFileWriter;
import org.tritonus.share.sampled.Encodings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioFileTypes {
    private static final String SERVICE_RESOURCE = "META-INF/services/org.corebounce.audio.file.FileReader";
    private static final ThreadLocal<AudioFileTypes> instances = new ThreadLocal();
    private static final Monitor readLock = new Monitor("JavaSound Reader SPI Lock");
    private static final Monitor writeLock = new Monitor("JavaSound Writer SPI Lock");
    private Map<String, Collection<String>> ext2fileReader = new HashMap<String, Collection<String>>();
    private Map<String, String> ext2Type = new LinkedHashMap<String, String>();
    private Map<String, AudioFileFormat.Type> ext2writeType = new LinkedHashMap<String, AudioFileFormat.Type>();

    private AudioFileTypes() {
    }

    public static synchronized AudioFileTypes instance() {
        AudioFileTypes result = instances.get();
        if (result == null) {
            result = new AudioFileTypes();
            instances.set(result);
            result.init();
        }
        return result;
    }

    protected void init() {
        AudioFileFormat.Type[] writeTypes;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> metaInfs = cl.getResources(SERVICE_RESOURCE);
            while (metaInfs.hasMoreElements()) {
                URL metaInf = metaInfs.nextElement();
                final LinkedHashMap props = new LinkedHashMap();
                Properties propParser = new Properties(){

                    public synchronized Object put(Object key, Object value) {
                        props.put(key, value);
                        return super.put(key, value);
                    }
                };
                try {
                    IOUtils.loadUtf8Properties(metaInf.openStream(), propParser);
                    for (Object key0 : props.keySet()) {
                        String ext;
                        String key = (String)key0;
                        if (key.startsWith("loader.")) {
                            ext = key.substring("loader".length()).toLowerCase();
                            String className = (String)props.get(key);
                            if (!StringUtils.isNotBlank(className) || !StringUtils.isNotBlank(ext.substring(1))) continue;
                            try {
                                Class.forName(className, false, cl);
                                Collection<String> classNames = this.ext2fileReader.get(ext);
                                if (classNames == null) {
                                    classNames = new ArrayList<String>();
                                    this.ext2fileReader.put(ext, classNames);
                                }
                                classNames.add(className);
                            }
                            catch (Throwable ex) {
                                Debug.warn("Cannot load JavaSound FileReader {0} for extension {1}", className, ext);
                                Debug.warn(ex);
                            }
                            continue;
                        }
                        if (!key.startsWith("type.")) continue;
                        ext = key.substring("type".length()).toLowerCase();
                        String type = (String)props.get(key);
                        if (!StringUtils.isNotBlank(type) || !StringUtils.isNotBlank(ext.substring(1))) continue;
                        this.ext2Type.put(ext, type);
                    }
                }
                catch (IOException ex) {
                    Debug.warn(ex);
                }
                catch (Exception ex) {
                    Debug.error(ex);
                }
            }
        }
        catch (IOException ex) {
            Debug.warn(ex);
        }
        for (String ext : this.ext2fileReader.keySet()) {
            String type = this.ext2Type.get(ext);
            if (type != null) continue;
            type = ext.substring(1).toUpperCase();
            this.ext2Type.put(ext, type);
        }
        Iterator<String> iter = this.ext2Type.keySet().iterator();
        while (iter.hasNext()) {
            String ext = iter.next();
            if (this.ext2fileReader.containsKey(ext)) continue;
            iter.remove();
        }
        if (!this.ext2Type.containsKey(".aiff")) {
            this.ext2Type.put(".aiff", "AIFF/AIFC");
        }
        if (!this.ext2Type.containsKey(".aifc")) {
            this.ext2Type.put(".aifc", "AIFF/AIFC");
        }
        if (!this.ext2Type.containsKey(".aif")) {
            this.ext2Type.put(".aif", "AIFF/AIFC");
        }
        if (!this.ext2Type.containsKey(".wav")) {
            this.ext2Type.put(".wav", "WAVE");
        }
        if (!this.ext2Type.containsKey(".au")) {
            this.ext2Type.put(".au", "AU");
        }
        if ((writeTypes = AudioSystem.getAudioFileTypes()) != null) {
            AudioFileFormat.Type[] typeArray = writeTypes;
            int n = writeTypes.length;
            int n2 = 0;
            while (n2 < n) {
                AudioFileFormat.Type type = typeArray[n2];
                String extension = type.getExtension();
                if (extension != null) {
                    if (!extension.startsWith(".")) {
                        extension = "." + extension;
                    }
                    this.ext2writeType.put(extension, type);
                }
                ++n2;
            }
        }
        if (!this.ext2writeType.containsKey(".aiff")) {
            this.ext2writeType.put(".aiff", AudioFileFormat.Type.AIFF);
        }
        if (!this.ext2writeType.containsKey(".aifc")) {
            this.ext2writeType.put(".aifc", AudioFileFormat.Type.AIFC);
        }
        if (!this.ext2writeType.containsKey(".aif")) {
            this.ext2writeType.put(".aif", AudioFileFormat.Type.AIFF);
        }
        if (!this.ext2writeType.containsKey(".wav")) {
            this.ext2writeType.put(".wav", AudioFileFormat.Type.WAVE);
        }
        if (!this.ext2writeType.containsKey(".au")) {
            this.ext2writeType.put(".au", AudioFileFormat.Type.AU);
        }
    }

    public Collection<String> getSupportedReadTypes() {
        return new TreeSet<String>(this.ext2Type.values());
    }

    public Collection<String> getSupportedWriteTypes() {
        TreeSet<String> result = new TreeSet<String>();
        for (String ext : this.ext2writeType.keySet()) {
            String type = this.ext2Type.get(ext);
            if (type == null) {
                type = ext.substring(1).toUpperCase();
            }
            result.add(type);
        }
        return result;
    }

    public Collection<String> getExtensionsForType(String type) {
        ArrayList<String> result = new ArrayList<String>();
        for (String ext : this.ext2Type.keySet()) {
            String extType = this.ext2Type.get(ext);
            if (!extType.equals(type)) continue;
            result.add(ext);
        }
        return result;
    }

    public Collection<String> getSupportedReadExtensions() {
        return Collections.unmodifiableSet(this.ext2Type.keySet());
    }

    public Collection<String> getSupportedWriteExtensions() {
        return Collections.unmodifiableSet(this.ext2writeType.keySet());
    }

    public AudioFormat.Encoding getEncodingFor(AudioFormat.Encoding encoding, int bitDepth) {
        if (encoding != null) {
            if (encoding.equals(AudioFormat.Encoding.PCM_SIGNED) && (bitDepth == 8 || bitDepth == 16 || bitDepth == 24 || bitDepth == 32)) {
                return AudioFormat.Encoding.PCM_SIGNED;
            }
            if (encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED) && bitDepth == 8) {
                return AudioFormat.Encoding.PCM_UNSIGNED;
            }
            if (encoding.equals(Encodings.PCM_IEEE_FLOAT) && (bitDepth == 32 || bitDepth == 64)) {
                return Encodings.PCM_IEEE_FLOAT;
            }
        }
        if (bitDepth == 8) {
            return AudioFormat.Encoding.PCM_UNSIGNED;
        }
        if (bitDepth == 16 || bitDepth == 24) {
            return AudioFormat.Encoding.PCM_SIGNED;
        }
        if (bitDepth == 32 || bitDepth == 64) {
            return Encodings.PCM_IEEE_FLOAT;
        }
        return null;
    }

    public String getAudioFileType(String fileName) {
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot < 0) {
            return null;
        }
        String ext = fileName.substring(lastDot).toLowerCase();
        return this.ext2Type.get(ext);
    }

    public String getAudioFileType(AudioFileFormat.Type fileType) {
        for (Map.Entry<String, AudioFileFormat.Type> entry : this.ext2writeType.entrySet()) {
            if (!entry.getValue().equals(fileType)) continue;
            String ext = entry.getKey();
            return this.ext2Type.get(ext);
        }
        return null;
    }

    public AudioFileFormat.Type getWritableType(String type) {
        for (String ext : this.getExtensionsForType(type)) {
            AudioFileFormat.Type result = this.ext2writeType.get(ext);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public AudioFileFormat.Type getWritableType4ext(String fileName) {
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot < 0) {
            return null;
        }
        String extension = fileName.substring(lastDot);
        return this.ext2writeType.get(extension);
    }

    public AudioFileFormat.Type getPlatformDefaultType() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("windows")) {
            return AudioFileFormat.Type.WAVE;
        }
        if (osName.contains("mac")) {
            return AudioFileFormat.Type.AIFF;
        }
        return AudioFileFormat.Type.AU;
    }

    protected AudioFileReader getAudioFileReader(String fileName) throws IOException {
        String extension;
        Collection<String> fileReaderClassNames;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot >= 0 && (fileReaderClassNames = this.ext2fileReader.get(extension = fileName.substring(lastDot).toLowerCase())) != null) {
            for (String fileReaderClassName : fileReaderClassNames) {
                try {
                    Class<?> clazz = Class.forName(fileReaderClassName, true, classLoader);
                    AudioFileReader reader = (AudioFileReader)clazz.newInstance();
                    return reader;
                }
                catch (Exception ex) {
                    Debug.error(ex);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioInputStream getAudioInputStream(String fileName, InputStream fileInput) throws IOException, UnsupportedAudioFileException {
        Monitor monitor = readLock;
        synchronized (monitor) {
            AudioFileReader reader = this.getAudioFileReader(fileName);
            if (reader != null) {
                try {
                    return reader.getAudioInputStream(fileInput);
                }
                catch (IOException ex) {
                    Debug.warn(ex);
                }
                catch (UnsupportedAudioFileException ex) {
                    Debug.warn(ex);
                }
            }
            Debug.warn("Using JavaSound''s AudioSystem to open file {0}", fileName);
            return AudioSystem.getAudioInputStream(fileInput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int write(AudioInputStream stream, AudioFileFormat.Type fileType, OutputStream out) throws IOException {
        Monitor monitor = writeLock;
        synchronized (monitor) {
            if (fileType.equals(AudioFileFormat.Type.WAVE)) {
                WaveAudioFileWriter writer = new WaveAudioFileWriter();
                return writer.write(stream, fileType, out);
            }
            if (fileType.equals(AudioFileFormat.Type.AIFF) || fileType.equals(AudioFileFormat.Type.AIFC)) {
                AiffAudioFileWriter writer = new AiffAudioFileWriter();
                return writer.write(stream, fileType, out);
            }
            if (fileType.equals(AudioFileFormat.Type.AU)) {
                AuAudioFileWriter writer = new AuAudioFileWriter();
                return writer.write(stream, fileType, out);
            }
            return AudioSystem.write(stream, fileType, out);
        }
    }

    public AudioFileFormat getAudioFileFormat(File file) throws IOException, UnsupportedAudioFileException {
        RandomFileInputStream fileInput = new RandomFileInputStream(file);
        try {
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(file.getName(), fileInput);
            return audioFileFormat;
        }
        finally {
            ((InputStream)fileInput).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFileFormat getAudioFileFormat(String fileName, InputStream fileInput) throws IOException, UnsupportedAudioFileException {
        Monitor monitor = readLock;
        synchronized (monitor) {
            AudioFileReader reader = this.getAudioFileReader(fileName);
            if (reader != null) {
                try {
                    return reader.getAudioFileFormat(fileInput);
                }
                catch (IOException ex) {
                    Debug.warn(ex);
                }
            }
            return AudioSystem.getAudioFileFormat(fileInput);
        }
    }
}

