/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.iir;

import org.corebounce.common.dsp.iir.Complex;
import org.corebounce.common.dsp.iir.DFilterFrame;
import org.corebounce.common.dsp.iir.PoleFilterType;

abstract class EllipticFilterType
extends PoleFilterType {
    private final DFilterFrame dFilterFrame;
    double p0;
    double q;
    double[] zeros;
    double K;
    double Kprime;
    double[] c1 = new double[100];
    double[] b1 = new double[100];
    double[] a1 = new double[100];
    double[] d1 = new double[100];
    double[] q1 = new double[100];
    double[] z1 = new double[100];
    double[] f1 = new double[100];
    double[] s1 = new double[100];
    double[] p = new double[100];
    double[] zw1 = new double[100];
    double[] zf1 = new double[100];
    double[] zq1 = new double[100];
    double[] rootR = new double[100];
    double[] rootI = new double[100];
    int nin;
    int m;
    int n2;
    int em;
    double e;

    EllipticFilterType(DFilterFrame dFilterFrame) {
        super(dFilterFrame);
        this.dFilterFrame = dFilterFrame;
    }

    void selectElliptic(int s) {
        this.dFilterFrame.auxLabels[s].setText("Passband Ripple");
        this.dFilterFrame.auxBars[s].setValue(60);
        this.dFilterFrame.auxLabels[s + 1].setText("Transition Band Width");
        this.dFilterFrame.auxBars[s + 1].setValue(100);
    }

    void setupElliptic(int a) {
        double rp = (double)this.dFilterFrame.auxBars[a].getValue() / 25.0;
        double xi = (Math.exp((double)this.dFilterFrame.auxBars[a + 1].getValue() / 1000.0) - 1.0) * 5.0 + 1.0;
        this.Kprime = this.ellipticK(Math.sqrt(1.0 - 1.0 / (xi * xi)));
        this.K = this.ellipticK(1.0 / xi);
        int ni = (this.n & 1) == 1 ? 0 : 1;
        double[] f = new double[this.n / 2 + 1];
        this.zeros = new double[this.n + 1];
        int i = 1;
        while (i <= this.n / 2) {
            double u = (double)(2 * i - ni) * this.K / (double)this.n;
            double sn = this.calcSn(u);
            double d = 1.0 / (sn *= Math.PI * 2 / this.K);
            this.zeros[i - 1] = d;
            f[i] = d;
            ++i;
        }
        this.zeros[this.n / 2] = 1.0E30;
        double fb = 0.15915494309189535;
        this.nin = this.n % 2;
        this.n2 = this.n / 2;
        i = 1;
        while (i <= this.n2) {
            double x = f[this.n2 + 1 - i];
            this.z1[i] = Math.sqrt(1.0 - 1.0 / (x * x));
            ++i;
        }
        double ee = Math.pow(10.0, 0.1 * rp) - 1.0;
        this.e = Math.sqrt(ee);
        double fbb = fb * fb;
        this.m = this.nin + 2 * this.n2;
        this.em = 2 * (this.m / 2);
        double tp = Math.PI * 2;
        this.calcfz();
        this.calcqz();
        if (this.m > this.em) {
            this.c1[2 * this.m] = 0.0;
        }
        i = 0;
        while (i <= 2 * this.m) {
            this.a1[this.m - i / 2] = this.c1[i] + this.d1[i];
            i += 2;
        }
        double a0 = this.factorFinder(this.m);
        int r = 0;
        while (r < this.em / 2) {
            int n = ++r;
            this.p[n] = this.p[n] / 10.0;
            int n2 = r;
            this.q1[n2] = this.q1[n2] / 100.0;
            double d = 1.0 + this.p[r] + this.q1[r];
            this.b1[r] = (1.0 + this.p[r] / 2.0) * fbb / d;
            this.zf1[r] = fb / Math.pow(d, 0.25);
            this.zq1[r] = 1.0 / Math.sqrt(Math.abs(2.0 * (1.0 - this.b1[r] / (this.zf1[r] * this.zf1[r]))));
            this.zw1[r] = tp * this.zf1[r];
            this.rootR[r] = -0.5 * this.zw1[r] / this.zq1[r];
            this.rootR[r + this.em / 2] = this.rootR[r];
            this.rootI[r] = 0.5 * Math.sqrt(Math.abs(this.zw1[r] * this.zw1[r] / (this.zq1[r] * this.zq1[r]) - 4.0 * this.zw1[r] * this.zw1[r]));
            this.rootI[r + this.em / 2] = -this.rootI[r];
        }
        if (a0 != 0.0) {
            this.rootR[r + 1 + this.em / 2] = -Math.sqrt(fbb / (0.1 * a0 - 1.0)) * tp;
            this.rootI[r + 1 + this.em / 2] = 0.0;
        }
    }

    void calcfz() {
        int i = 1;
        if (this.nin == 1) {
            this.s1[i++] = 1.0;
        }
        while (i <= this.nin + this.n2) {
            double d = this.z1[i - this.nin];
            this.s1[i + this.n2] = d;
            this.s1[i] = d;
            ++i;
        }
        this.genProductPoly(this.nin + 2 * this.n2);
        i = 0;
        while (i <= this.em) {
            this.a1[i] = this.e * this.b1[i];
            i += 2;
        }
        i = 0;
        while (i <= 2 * this.em) {
            this.calcfz2(i);
            i += 2;
        }
    }

    void genProductPoly(int sn) {
        this.b1[0] = this.s1[1];
        this.b1[1] = 1.0;
        int j = 2;
        while (j <= sn) {
            this.a1[0] = this.s1[j] * this.b1[0];
            int i = 1;
            while (i <= j - 1) {
                this.a1[i] = this.b1[i - 1] + this.s1[j] * this.b1[i];
                ++i;
            }
            i = 0;
            while (i != j) {
                this.b1[i] = this.a1[i];
                ++i;
            }
            this.b1[j] = 1.0;
            ++j;
        }
    }

    void calcfz2(int i) {
        int ji = 0;
        int jf = 0;
        if (i < this.em + 2) {
            ji = 0;
            jf = i;
        }
        if (i > this.em) {
            ji = i - this.em;
            jf = this.em;
        }
        this.c1[i] = 0.0;
        int j = ji;
        while (j <= jf) {
            int n = i;
            this.c1[n] = this.c1[n] + this.a1[j] * (this.a1[i - j] * Math.pow(10.0, this.m - i / 2));
            j += 2;
        }
    }

    void calcqz() {
        int i = 1;
        while (i <= this.nin) {
            this.s1[i] = -10.0;
            ++i;
        }
        while (i <= this.nin + this.n2) {
            this.s1[i] = -10.0 * this.z1[i - this.nin] * this.z1[i - this.nin];
            ++i;
        }
        while (i <= this.nin + 2 * this.n2) {
            this.s1[i] = this.s1[i - this.n2];
            ++i;
        }
        this.genProductPoly(this.m);
        int dd = (this.nin & 1) == 1 ? -1 : 1;
        i = 0;
        while (i <= 2 * this.m) {
            this.d1[i] = (double)dd * this.b1[i / 2];
            i += 2;
        }
    }

    double factorFinder(int t) {
        double a = 0.0;
        int i = 1;
        while (i <= t) {
            int n = i++;
            this.a1[n] = this.a1[n] / this.a1[0];
        }
        this.c1[0] = 1.0;
        this.b1[0] = 1.0;
        this.a1[0] = 1.0;
        int i1 = 0;
        while (t > 2) {
            double dq;
            double ddp;
            double p0 = 0.0;
            double q0 = 0.0;
            ++i1;
            do {
                this.b1[1] = this.a1[1] - p0;
                this.c1[1] = this.b1[1] - p0;
                i = 2;
                while (i <= t) {
                    this.b1[i] = this.a1[i] - p0 * this.b1[i - 1] - q0 * this.b1[i - 2];
                    ++i;
                }
                i = 2;
                while (i < t) {
                    this.c1[i] = this.b1[i] - p0 * this.c1[i - 1] - q0 * this.c1[i - 2];
                    ++i;
                }
                int x2 = t - 2;
                int x3 = t - 3;
                int x1 = t - 1;
                double x4 = this.c1[x2] * this.c1[x2] + this.c1[x3] * (this.b1[x1] - this.c1[x1]);
                if (x4 == 0.0) {
                    x4 = 0.001;
                }
                ddp = (this.b1[x1] * this.c1[x2] - this.b1[t] * this.c1[x3]) / x4;
                p0 += ddp;
                dq = (this.b1[t] * this.c1[x2] - this.b1[x1] * (this.c1[x1] - this.b1[x1])) / x4;
                q0 += dq;
            } while (!(Math.abs(ddp + dq) < 1.0E-6));
            this.p[i1] = p0;
            this.q1[i1] = q0;
            this.a1[1] = this.a1[1] - p0;
            t -= 2;
            i = 2;
            while (i <= t) {
                int n = i;
                this.a1[n] = this.a1[n] - (p0 * this.a1[i - 1] + q0 * this.a1[i - 2]);
                ++i;
            }
            if (t > 2) continue;
        }
        if (t == 2) {
            this.p[++i1] = this.a1[1];
            this.q1[i1] = this.a1[2];
        }
        if (t == 1) {
            a = -this.a1[1];
        }
        return a;
    }

    double calcSn(double u) {
        double sn = 0.0;
        double q = Math.exp(-Math.PI * this.Kprime / this.K);
        double v = 1.5707963267948966 * u / this.K;
        int j = 0;
        while (true) {
            double w = Math.pow(q, (double)j + 0.5);
            sn += w * Math.sin((double)(2 * j + 1) * v) / (1.0 - w * w);
            if (w < 1.0E-7) break;
            ++j;
        }
        return sn;
    }

    double ellipticK(double k) {
        double e;
        double[] a = new double[50];
        double[] theta = new double[50];
        a[0] = Math.atan(k / Math.sqrt(1.0 - k * k));
        theta[0] = 1.5707963267948966;
        int i = 0;
        do {
            double x = 2.0 / (1.0 + Math.sin(a[i])) - 1.0;
            double y = Math.sin(a[i]) * Math.sin(theta[i]);
            a[i + 1] = Math.atan(Math.sqrt(1.0 - x * x) / x);
            theta[i + 1] = 0.5 * (theta[i] + Math.atan(y / Math.sqrt(1.0 - y * y)));
        } while (!((e = 1.0 - a[i + 1] * 2.0 / Math.PI) < 1.0E-7) && ++i != 49);
        double p = 1.0;
        int j = 1;
        while (j <= i) {
            p *= 1.0 + Math.cos(a[j]);
            ++j;
        }
        double x = 0.7853981633974483 + theta[i] / 2.0;
        return Math.log(Math.tan(x)) * p;
    }

    void getSPole(int i, Complex c1, double wc) {
        double tanwc = Math.tan(wc * 0.5);
        c1.set(this.rootR[i + 1] * tanwc, this.rootI[i + 1] * tanwc);
    }

    void getEllipticZero(int i, Complex c1, double wc) {
        double tanwc = Math.tan(wc * 0.5);
        c1.set(0.0, this.zeros[i / 2] * tanwc);
        if ((i & 1) == 1) {
            c1.im = -c1.im;
        }
        this.bilinearXform(c1);
    }

    void getInfoElliptic(String[] x) {
    }

    int getPoleCount() {
        return this.n;
    }

    int getZeroCount() {
        return this.n;
    }
}

