/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.iir;

import org.corebounce.common.dsp.iir.ChebyFilterType;
import org.corebounce.common.dsp.iir.Complex;
import org.corebounce.common.dsp.iir.DFilterFrame;

abstract class InvChebyFilterType
extends ChebyFilterType {
    private final DFilterFrame dFilterFrame;
    double scale;

    InvChebyFilterType(DFilterFrame dFilterFrame) {
        super(dFilterFrame);
        this.dFilterFrame = dFilterFrame;
    }

    void selectCheby(int s) {
        this.dFilterFrame.auxLabels[s].setText("Stopband Attenuation");
        this.dFilterFrame.auxBars[s].setValue(600);
    }

    void setupCheby(int a) {
        this.epsilon = Math.exp((double)(-this.dFilterFrame.auxBars[a].getValue()) / 120.0);
        this.scale = this.dFilterFrame.cosh(this.dFilterFrame.acosh(1.0 / this.epsilon) / (double)this.n);
    }

    void getSPole(int i, Complex c1, double wc) {
        wc = Math.PI - wc;
        super.getSPole(i, c1, wc);
        c1.recip();
        c1.mult(this.scale);
    }

    void getChebyZero(int i, Complex c1, double wc) {
        double bk = 1.0 / Math.cos((double)(2 * i + 1) * Math.PI / (double)(2 * this.n)) * this.scale;
        double a = Math.sin(0.7853981633974483 - wc / 2.0) / Math.sin(0.7853981633974483 + wc / 2.0);
        c1.set(1.0 + a, bk * (1.0 - a));
        Complex c2 = new Complex(1.0 + a, bk * (a - 1.0));
        c1.div(c2);
    }

    void getInfoCheby(String[] x) {
        x[2] = "Stopband attenuation: " + this.dFilterFrame.showFormat.format(-10.0 * Math.log(1.0 + 1.0 / (this.epsilon * this.epsilon)) / 2.302585092994046) + " dB";
    }

    int getPoleCount() {
        return this.n;
    }

    int getZeroCount() {
        return this.n;
    }
}

