/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.mfcc;

import org.corebounce.common.dsp.mfcc.DCT;
import org.corebounce.common.dsp.mfcc.FFT;

public class MFCC {
    private int numMelFilters = 30;
    private int numCepstra;
    private double preEmphasisAlpha = 0.95;
    private double lowerFilterFreq = 80.0;
    private double samplingRate;
    private double upperFilterFreq;
    private double[] bin;
    private int samplePerFrame;
    FFT fft;
    DCT dct;

    public MFCC(int samplePerFrame, int samplingRate, int numCepstra) {
        this.samplePerFrame = samplePerFrame;
        this.samplingRate = samplingRate;
        this.numCepstra = numCepstra;
        this.upperFilterFreq = (double)samplingRate / 2.0;
        this.fft = new FFT();
        this.dct = new DCT(this.numCepstra, this.numMelFilters);
    }

    public double[] doMFCC(float[] framedSignal) {
        this.bin = this.magnitudeSpectrum(framedSignal);
        framedSignal = this.preEmphasis(framedSignal);
        int[] cbin = this.fftBinIndices();
        double[] fbank = this.melFilter(this.bin, cbin);
        double[] f = this.nonLinearTransformation(fbank);
        double[] cepc = this.dct.performDCT(f);
        return cepc;
    }

    private double[] magnitudeSpectrum(float[] frame) {
        double[] magSpectrum = new double[frame.length];
        this.fft.computeFFT(frame);
        int k = 0;
        while (k < frame.length) {
            magSpectrum[k] = Math.sqrt(this.fft.real[k] * this.fft.real[k] + this.fft.imag[k] * this.fft.imag[k]);
            ++k;
        }
        return magSpectrum;
    }

    private float[] preEmphasis(float[] inputSignal) {
        float[] outputSignal = new float[inputSignal.length];
        int n = 1;
        while (n < inputSignal.length) {
            outputSignal[n] = (float)((double)inputSignal[n] - this.preEmphasisAlpha * (double)inputSignal[n - 1]);
            ++n;
        }
        return outputSignal;
    }

    private int[] fftBinIndices() {
        int[] cbin = new int[this.numMelFilters + 2];
        cbin[0] = (int)Math.round(this.lowerFilterFreq / this.samplingRate * (double)this.samplePerFrame);
        cbin[cbin.length - 1] = this.samplePerFrame / 2;
        int i = 1;
        while (i <= this.numMelFilters) {
            double fc = this.centerFreq(i);
            cbin[i] = (int)Math.round(fc / this.samplingRate * (double)this.samplePerFrame);
            ++i;
        }
        return cbin;
    }

    private double[] melFilter(double[] bin, int[] cbin) {
        double[] temp = new double[this.numMelFilters + 2];
        int k = 1;
        while (k <= this.numMelFilters) {
            double num1 = 0.0;
            double num2 = 0.0;
            int i = cbin[k - 1];
            while (i <= cbin[k]) {
                num1 += (double)((i - cbin[k - 1] + 1) / (cbin[k] - cbin[k - 1] + 1)) * bin[i];
                ++i;
            }
            i = cbin[k] + 1;
            while (i <= cbin[k + 1]) {
                num2 += (double)(1 - (i - cbin[k]) / (cbin[k + 1] - cbin[k] + 1)) * bin[i];
                ++i;
            }
            temp[k] = num1 + num2;
            ++k;
        }
        double[] fbank = new double[this.numMelFilters];
        int i = 0;
        while (i < this.numMelFilters) {
            fbank[i] = temp[i + 1];
            ++i;
        }
        return fbank;
    }

    private double[] nonLinearTransformation(double[] fbank) {
        double[] f = new double[fbank.length];
        double FLOOR = -50.0;
        int i = 0;
        while (i < fbank.length) {
            f[i] = Math.log(fbank[i]);
            if (f[i] < -50.0) {
                f[i] = -50.0;
            }
            ++i;
        }
        return f;
    }

    private double centerFreq(int i) {
        double melFLow = this.freqToMel(this.lowerFilterFreq);
        double melFHigh = this.freqToMel(this.upperFilterFreq);
        double temp = melFLow + (melFHigh - melFLow) / (double)(this.numMelFilters + 1) * (double)i;
        return this.inverseMel(temp);
    }

    private double inverseMel(double x) {
        double temp = Math.pow(10.0, x / 2595.0) - 1.0;
        return 700.0 * temp;
    }

    protected double freqToMel(double freq) {
        return 2595.0 * this.log10(1.0 + freq / 700.0);
    }

    private double log10(double value) {
        return Math.log(value) / Math.log(10.0);
    }
}

