/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.resample;

import java.util.Arrays;
import org.corebounce.common.dsp.resample.IAudioSource;
import org.corebounce.common.dsp.resample.IResampler;

public abstract class BufferedResampler
implements IResampler {
    private final IAudioSource source;
    private final float[] buffer;
    protected final int bufferSize;
    private final int historySize;
    protected int eosIndex;

    public BufferedResampler(IAudioSource source, int bufferSize, int historySize) {
        this.source = source;
        this.buffer = new float[bufferSize + historySize];
        this.bufferSize = bufferSize;
        this.historySize = historySize;
        this.eosIndex = bufferSize;
    }

    public void reset() {
        Arrays.fill(this.buffer, 0.0f);
        this.eosIndex = this.bufferSize;
    }

    protected int prefetch(int sampleIndex) {
        int result = 0;
        while (sampleIndex >= this.buffer.length) {
            this.fetchNextBuffer();
            sampleIndex -= this.bufferSize;
            result += this.bufferSize;
        }
        return result;
    }

    protected final float getSample(int sampleIndex) {
        return this.buffer[sampleIndex];
    }

    protected void fetchNextBuffer() {
        if (this.historySize > 0) {
            System.arraycopy(this.buffer, this.buffer.length - this.historySize, this.buffer, 0, this.historySize);
        }
        this.eosIndex += this.source.getSamples(this.buffer, this.historySize, this.bufferSize);
        this.eosIndex -= this.bufferSize;
    }

    protected IAudioSource getAudioSource() {
        return this.source;
    }
}

