/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.gui;

import java.util.HashMap;
import java.util.Map;
import org.corebounce.common.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlEncoder {
    private static Map<String, String> charsToCode;
    private static Map<String, String> codeToChars;

    private static void setCharCode(String ch, String code) {
        charsToCode.put(ch, code);
        codeToChars.put(code, ch);
    }

    private static synchronized void initSpecialChars() {
        if (charsToCode == null) {
            charsToCode = new HashMap<String, String>();
            codeToChars = new HashMap<String, String>();
            HtmlEncoder.setCharCode("<", "lt");
            HtmlEncoder.setCharCode(">", "gt");
            HtmlEncoder.setCharCode("\"", "quot");
            HtmlEncoder.setCharCode("'", "&apos");
            HtmlEncoder.setCharCode("&", "amp");
            HtmlEncoder.setCharCode("\u00a0", "nbsp");
            HtmlEncoder.setCharCode("\u00c0", "Agrave");
            HtmlEncoder.setCharCode("\u00c1", "Aacute");
            HtmlEncoder.setCharCode("\u00c2", "Acirc");
            HtmlEncoder.setCharCode("\u00c3", "Atilde");
            HtmlEncoder.setCharCode("\u00c4", "Auml");
            HtmlEncoder.setCharCode("\u00c8", "Egrave");
            HtmlEncoder.setCharCode("\u00c9", "Eacute");
            HtmlEncoder.setCharCode("\u00ca", "Ecirc");
            HtmlEncoder.setCharCode("\u00cb", "Euml");
            HtmlEncoder.setCharCode("\u00cc", "Igrave");
            HtmlEncoder.setCharCode("\u00cd", "Iacute");
            HtmlEncoder.setCharCode("\u00ce", "Icirc");
            HtmlEncoder.setCharCode("\u00cf", "Iuml");
            HtmlEncoder.setCharCode("\u00d1", "Ntilde");
            HtmlEncoder.setCharCode("\u00d2", "Ograve");
            HtmlEncoder.setCharCode("\u00d3", "Oacute");
            HtmlEncoder.setCharCode("\u00d4", "Ocirc");
            HtmlEncoder.setCharCode("\u00d5", "Otilde");
            HtmlEncoder.setCharCode("\u00d6", "Ouml");
            HtmlEncoder.setCharCode("\u00d9", "Ugrave");
            HtmlEncoder.setCharCode("\u00da", "Uacute");
            HtmlEncoder.setCharCode("\u00db", "Ucirc");
            HtmlEncoder.setCharCode("\u00dc", "Uuml");
            HtmlEncoder.setCharCode("\u00dd", "Yacute");
            HtmlEncoder.setCharCode("\u00e0", "agrave");
            HtmlEncoder.setCharCode("\u00e1", "aacute");
            HtmlEncoder.setCharCode("\u00e2", "acirc");
            HtmlEncoder.setCharCode("\u00e3", "atilde");
            HtmlEncoder.setCharCode("\u00e4", "auml");
            HtmlEncoder.setCharCode("\u00e7", "ccedil");
            HtmlEncoder.setCharCode("\u00e8", "egrave");
            HtmlEncoder.setCharCode("\u00e9", "eacute");
            HtmlEncoder.setCharCode("\u00ea", "ecirc");
            HtmlEncoder.setCharCode("\u00eb", "euml");
            HtmlEncoder.setCharCode("\u00ec", "igrave");
            HtmlEncoder.setCharCode("\u00ed", "iacute");
            HtmlEncoder.setCharCode("\u00ee", "icirc");
            HtmlEncoder.setCharCode("\u00ef", "iuml");
            HtmlEncoder.setCharCode("\u00f1", "ntilde");
            HtmlEncoder.setCharCode("\u00f2", "ograve");
            HtmlEncoder.setCharCode("\u00f3", "oacute");
            HtmlEncoder.setCharCode("\u00f4", "ocirc");
            HtmlEncoder.setCharCode("\u00f5", "otilde");
            HtmlEncoder.setCharCode("\u00f6", "ouml");
            HtmlEncoder.setCharCode("\u00f9", "ugrave");
            HtmlEncoder.setCharCode("\u00fa", "uacute");
            HtmlEncoder.setCharCode("\u00fb", "ucirc");
            HtmlEncoder.setCharCode("\u00fc", "uuml");
            HtmlEncoder.setCharCode("\u00fd", "yacute");
            HtmlEncoder.setCharCode("\u00ff", "yuml");
        }
    }

    private static Map<String, String> getCharsToCodeMap() {
        HtmlEncoder.initSpecialChars();
        return charsToCode;
    }

    private static Map<String, String> getCodeToCharsMap() {
        HtmlEncoder.initSpecialChars();
        return codeToChars;
    }

    private static String escapeHTML(Map<String, String> charsToCode, char ch) {
        if (ch >= ' ' && ch < '\u007f') {
            switch (ch) {
                case '<': {
                    return "&lt;";
                }
                case '>': {
                    return "&gt;";
                }
                case '\"': {
                    return "&quot;";
                }
                case '&': {
                    return "&amp;";
                }
            }
            return "" + ch;
        }
        if (ch == '\n') {
            return "<br>";
        }
        if (ch == '\r' || ch == '\t') {
            return "" + ch;
        }
        String key = "" + ch;
        String code = charsToCode.get(key);
        if (code != null) {
            return "&" + code + ";";
        }
        return "&#" + String.valueOf((int)ch) + ";";
    }

    public static String escape(String text) {
        Map<String, String> charsToCode = HtmlEncoder.getCharsToCodeMap();
        char[] source = text.toCharArray();
        StringBuilder buffer = new StringBuilder(source.length + 100);
        int i = 0;
        while (i < source.length) {
            buffer.append(HtmlEncoder.escapeHTML(charsToCode, source[i]));
            ++i;
        }
        return buffer.toString();
    }

    public static String unescape(String html) {
        Map<String, String> codeToChars = HtmlEncoder.getCodeToCharsMap();
        char[] source = html.toCharArray();
        StringBuffer buffer = new StringBuffer(source.length);
        int i = 0;
        while (i < source.length) {
            if (source[i] == '&') {
                int j = i + 1;
                while (j < source.length && source[j] != ';' && j < i + 8) {
                    ++j;
                }
                if (j < source.length && source[j] == ';') {
                    if (source[i + 1] == '#') {
                        int code = Integer.parseInt(new String(source, i + 2, j - i - 2));
                        buffer.append((char)code);
                    } else {
                        String name = new String(source, i + 1, j - i - 1);
                        String ch = codeToChars.get(name);
                        if (ch != null) {
                            buffer.append(ch);
                        } else {
                            buffer.append('\u00a0');
                        }
                    }
                    i = j + 1;
                    continue;
                }
                buffer.append(source[i++]);
                continue;
            }
            buffer.append(source[i++]);
        }
        return buffer.toString();
    }

    public static String escape(String htmlFragment, Object ... args) {
        Object[] parts = new String[args.length];
        int i = 0;
        while (i < args.length) {
            parts[i] = HtmlEncoder.escape(String.valueOf(args[i]));
            ++i;
        }
        return StringUtils.format(htmlFragment, parts);
    }
}

