/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.log;

import ch.tachyon.tunnel.utils.Utils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.corebounce.common.log.EventTrace;
import org.corebounce.common.log.LogEntry;

public class LogFormatter
extends Formatter {
    public String format(LogRecord record) {
        StringBuilder formattedMessage = new StringBuilder();
        String message = record.getMessage();
        if (message == null) {
            message = "";
        }
        message = message.replace('\n', ' ');
        if (record.getParameters() != null && record.getParameters().length > 0) {
            formattedMessage.append(MessageFormat.format(message, record.getParameters()));
        } else {
            formattedMessage.append(message);
        }
        Throwable ex = record.getThrown();
        if (ex != null) {
            formattedMessage.append(Utils.NEW_LINE);
            StringWriter writer = new StringWriter();
            ex.printStackTrace(new PrintWriter(writer));
            formattedMessage.append(writer.getBuffer());
        }
        LogEntry entry = new LogEntry(record.getMillis(), record.getLevel(), record.getSourceClassName(), record.getSourceMethodName(), formattedMessage.toString());
        EventTrace.addLogEntry(entry);
        return String.valueOf(entry.toString()) + Utils.NEW_LINE;
    }

    public static void setup() {
        LogFormatter formatter = new LogFormatter();
        Handler[] handlerArray = Logger.getLogger("").getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            handler.setFormatter(formatter);
            ++n2;
        }
        Logger.getLogger("").setLevel(Level.WARNING);
    }

    public static void setupAfterSwingStart() {
        Logger.getLogger("").setLevel(Level.WARNING);
    }
}

