/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.struct;

import ch.tachyon.tunnel.utils.Monitor;
import java.lang.ref.Reference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.corebounce.common.struct.WeakCacheReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakCacheMap<K, V>
extends AbstractMap<K, V> {
    private static final int MIN_SIZE = 100;
    private static final int SHRINK_FACTOR = 4;
    private int maxSizeSoFar = 0;
    private transient EntrySet entrySet;
    private Map<K, WeakCacheReference<K, V>> target = new HashMap<K, WeakCacheReference<K, V>>();
    private final Object targetLock = new Monitor("WeakCache.target");

    private WeakCacheReference<K, V> wrap(K key, V item) {
        return new WeakCacheReference<K, V>(this, key, item);
    }

    private V unwrap(Reference<V> ref) {
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sizeChanged() {
        int curSize = this.size();
        this.maxSizeSoFar = Math.max(this.maxSizeSoFar, curSize);
        if (this.maxSizeSoFar >= 400) {
            Object object = this.targetLock;
            synchronized (object) {
                int newSize = this.size();
                if (newSize * 4 <= this.maxSizeSoFar) {
                    Map<K, WeakCacheReference<K, V>> previous = this.target;
                    this.target = new HashMap<K, WeakCacheReference<K, V>>(newSize);
                    Iterator<Map.Entry<K, WeakCacheReference<K, V>>> iter = previous.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<K, WeakCacheReference<K, V>> entry = iter.next();
                        this.target.put(entry.getKey(), entry.getValue());
                        iter.remove();
                    }
                    this.maxSizeSoFar = newSize;
                }
            }
        }
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.target.containsKey(key);
    }

    @Override
    public synchronized V get(Object key) {
        return this.unwrap(this.target.get(key));
    }

    @Override
    public synchronized V put(K key, V value) {
        V result = this.unwrap(this.target.put(key, this.wrap(key, value)));
        this.sizeChanged();
        return result;
    }

    @Override
    public synchronized V remove(Object key) {
        V result = this.unwrap(this.target.remove(key));
        this.sizeChanged();
        return result;
    }

    @Override
    public synchronized int size() {
        return this.target.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized String toString() {
        return this.target.toString();
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (o instanceof WeakCacheMap) {
            WeakCacheMap other = (WeakCacheMap)o;
            return this.target.equals(other.target);
        }
        return false;
    }

    @Override
    public synchronized int hashCode() {
        return this.target.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return WeakCacheMap.this.size();
        }

        @Override
        public boolean add(Map.Entry<K, V> o) {
            return WeakCacheMap.this.put(o.getKey(), o.getValue()) == null;
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                return WeakCacheMap.this.containsKey(entry.getKey());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            return WeakCacheMap.this.remove(o) != null;
        }
    }
}

