/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.struct;

import java.lang.ref.WeakReference;
import org.corebounce.common.struct.WeakCacheMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WeakCacheReference<K, V>
extends WeakReference<V> {
    private final WeakCacheMap<K, V> cacheMap;
    private final K key;

    public WeakCacheReference(WeakCacheMap<K, V> cacheMap, K key, V referent) {
        super(referent);
        this.cacheMap = cacheMap;
        this.key = key;
    }

    public K getKey() {
        return this.key;
    }

    void dispose() {
        this.cacheMap.remove(this.getKey());
    }

    WeakCacheMap<K, V> getCacheMap() {
        return this.cacheMap;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WeakCacheReference) {
            WeakCacheReference other = (WeakCacheReference)obj;
            Object otherItem = other.get();
            Object thisItem = this.get();
            if (otherItem == null) {
                return thisItem == null;
            }
            return otherItem.equals(thisItem);
        }
        return false;
    }

    public int hashCode() {
        Object item = this.get();
        if (item == null) {
            return 0;
        }
        return item.hashCode();
    }

    public String toString() {
        return "" + this.get();
    }
}

