/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.struct.skiplist;

import ch.tachyon.tunnel.utils.Pair;
import ch.tachyon.tunnel.utils.Utils;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;
import org.corebounce.common.struct.skiplist.IAggregator;
import org.corebounce.common.struct.skiplist.IHasCoverage;
import org.corebounce.common.struct.skiplist.ISkipNode;
import org.corebounce.common.struct.skiplist.SkipListAggregateView;
import org.corebounce.common.struct.skiplist.SkipListStruct;
import org.corebounce.common.struct.skiplist.SkipNodeManager;
import org.corebounce.common.utils.IDisposable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkipList<E>
extends AbstractList<E>
implements RandomAccess,
IDisposable {
    private final SkipListStruct<E> struct;
    private final SkipNodeManager<E> manager;
    private int lastIndex = Integer.MIN_VALUE;
    private ISkipNode<E> lastNode;

    public SkipList() {
        this(6);
    }

    public SkipList(int minSkipFactor) {
        this.struct = new SkipListStruct(minSkipFactor);
        this.manager = this.struct.getManager();
    }

    public SkipList(int minSkipFactor, SkipNodeManager<E> manager) {
        this.struct = new SkipListStruct<E>(minSkipFactor, manager);
        this.manager = manager;
    }

    public SkipList(int minSkipFactor, SkipNodeManager<E> manager, IAggregator<E> aggregator) {
        this(minSkipFactor, manager);
        this.struct.setAggregator(aggregator);
    }

    public SkipList(int minSkipFactor, IAggregator<E> aggregator) {
        this(minSkipFactor);
        this.struct.setAggregator(aggregator);
    }

    private void clearCache() {
        this.lastIndex = Integer.MIN_VALUE;
        this.lastNode = null;
    }

    private ISkipNode<E> indexToNode(int index) {
        ISkipNode<E> node;
        if (index == this.lastIndex) {
            node = this.lastNode;
        } else if (index == this.lastIndex + 1) {
            node = this.lastNode.getNext();
        } else if (index == this.lastIndex - 1) {
            node = this.lastNode.getPrev();
        } else if (index == 0) {
            node = this.manager.getFirst();
            node.setSrcPos(0L);
        } else {
            if (index == this.struct.getSize() - 1) {
                ISkipNode<E> node2 = this.manager.getLast();
                long srcPos = this.struct.getTotalCoverage() - node2.getCoverage();
                node2.setSrcPos(srcPos);
                return node2;
            }
            Pair<ISkipNode<E>[], ISkipNode<E>> location = this.struct.indexToLocation(index);
            node = location.getSecond();
        }
        this.lastIndex = index;
        this.lastNode = node;
        return node;
    }

    public ISkipNode<E> positionToNode(long position) {
        Pair<ISkipNode<E>[], ISkipNode<E>> location = this.struct.positionToLocation(position);
        return location.getSecond();
    }

    public ISkipNode<E> positionToNode(long position, long maxAvgCoverage) {
        Pair<ISkipNode<E>[], ISkipNode<E>> location = this.struct.positionToLocation(position);
        ISkipNode<E>[] path = location.getFirst();
        ISkipNode<E> result = location.getSecond();
        int level = 0;
        while (level < path.length) {
            long avgCoverage = this.struct.getAvgCoverage(level);
            if (avgCoverage > maxAvgCoverage) break;
            result = path[level];
            ++level;
        }
        return result;
    }

    public ISkipNode<E> headNodeOfLevel(int level) {
        if (level < 0) {
            return this.manager.getFirst();
        }
        List<ISkipNode<E>> headList = this.manager.headList();
        if (level < headList.size()) {
            return headList.get(level);
        }
        return null;
    }

    public int positionToIndex(long position) {
        int index = this.struct.positionToIndex(position);
        return index;
    }

    public void ensureAggregate(ISkipNode<E> node) {
        if (this.struct.getAggregator() == null) {
            throw new IllegalStateException("No IAggregator was specified for this list");
        }
        this.struct.ensureAggregate(node);
    }

    @Override
    public E get(int index) {
        ISkipNode<E> node = this.indexToNode(index);
        E result = node.getItem();
        return result;
    }

    @Override
    public E set(int index, E element) {
        Pair<ISkipNode<E>[], ISkipNode<E>> location = this.struct.indexToLocation(index);
        ISkipNode<E> node = location.getSecond();
        long oldCoverage = node.getCoverage();
        E result = node.getItem();
        node.setItem(element);
        long newCoverage = node.getCoverage();
        if (oldCoverage != newCoverage || this.struct.getAggregator() != null) {
            ISkipNode<E>[] path;
            long deltaCoverage = newCoverage - oldCoverage;
            this.struct.itemUpdated(deltaCoverage);
            ISkipNode<E>[] iSkipNodeArray = path = location.getFirst();
            int n = path.length;
            int n2 = 0;
            while (n2 < n) {
                ISkipNode parent = iSkipNodeArray[n2];
                if (deltaCoverage != 0L) {
                    parent.setCoverage(parent.getCoverage() + deltaCoverage);
                }
                this.struct.clearAggregate(parent);
                ++n2;
            }
        }
        return result;
    }

    private long coverage(E element) {
        if (element instanceof IHasCoverage) {
            return ((IHasCoverage)element).getCoverage();
        }
        return 1L;
    }

    @Override
    public void add(int index, E element) {
        ISkipNode<E> level0;
        this.clearCache();
        boolean isAtEnd = index == this.size();
        Pair<ISkipNode<E>[], ISkipNode<E>> location = this.struct.indexToLocation(index);
        ISkipNode<E>[] path = location.getFirst();
        ISkipNode<E> next = location.getSecond();
        ISkipNode<E> node = this.struct.newNode(-1, element);
        if (next != null) {
            ISkipNode<E> before = next.getPrev();
            if (before != null) {
                node.setSrcPos(before.getSrcPos() + before.getCoverage());
            } else {
                node.setSrcPos(0L);
            }
            node.setNext(next);
            node.setPrev(before);
            next.setPrev(node);
            if (before != null) {
                before.setNext(node);
            }
        } else {
            ISkipNode<E> last = this.manager.getLast();
            if (last != null) {
                long srcPos = this.struct.getTotalCoverage() - last.getCoverage();
                last.setSrcPos(srcPos);
                last.setNext(node);
            }
            node.setPrev(last);
            if (last != null) assert (last.getSrcPos() >= 0L);
            this.manager.setLast(node);
        }
        if (Utils.eq(this.manager.getFirst(), next)) {
            this.manager.setFirst(node);
        }
        if (Utils.eq((level0 = path[0]).getDown(), next)) {
            level0.setDown(node);
        }
        this.struct.itemAdded(path, this.coverage(element), isAtEnd);
    }

    @Override
    public E remove(int index) {
        this.clearCache();
        Pair<ISkipNode<E>[], ISkipNode<E>> location = this.struct.indexToLocation(index);
        ISkipNode<E>[] path = location.getFirst();
        ISkipNode<E> victim = location.getSecond();
        if (this.manager.getFirst().equals(victim)) {
            this.manager.setFirst(victim.getNext());
        }
        if (this.manager.getLast().equals(victim)) {
            this.manager.setLast(victim.getPrev());
        }
        ISkipNode<E> parent = path[0];
        assert (this.struct.isChild(parent, victim));
        if (parent.getDown().equals(victim)) {
            parent.setDown(victim.getNext());
        }
        this.struct.removeNode(victim);
        E result = victim.getItem();
        this.struct.itemRemoved(path, this.coverage(result));
        return result;
    }

    @Override
    public int size() {
        return this.struct.getSize();
    }

    public int getNbAggregateLevels() {
        return this.struct.getNblevels();
    }

    public SkipListAggregateView<E> getAggregateView(int level) {
        if (level < 0 || level >= this.getNbAggregateLevels()) {
            throw new IllegalArgumentException();
        }
        return new SkipListAggregateView<E>(this.struct, level);
    }

    public void assertCoherency() {
        this.struct.assertCoherency();
    }

    public String structToString() {
        return this.struct.toString();
    }

    @Override
    public void dispose() {
        if (this.manager instanceof IDisposable) {
            ((IDisposable)((Object)this.manager)).dispose();
        }
    }
}

