/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.test;

import ch.tachyon.tunnel.utils.Debug;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JFileChooser;
import org.corebounce.common.audio.device.AudioException;
import org.corebounce.common.audio.device.AudioIO;
import org.corebounce.common.audio.file.AudioFileFilter;
import org.corebounce.common.audio.file.AudioInputStreamSource;
import org.corebounce.common.gui.AwtTools;

public class AudioPlayTest {
    public static void main(String[] args) throws UnsupportedAudioFileException, IOException, AudioException, ClassNotFoundException {
        AwtTools.switchToNimbusLookAndFeel();
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(AudioFileFilter.readInstance());
        int result = chooser.showOpenDialog(null);
        if (result != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        AudioIO device = AudioIO.instance();
        int bufferSize = device.preferredFrameSize();
        AudioInputStream stream = AudioSystem.getAudioInputStream(file);
        AudioInputStreamSource source = new AudioInputStreamSource(stream);
        float[][] buffer = new float[source.getAudioFormat().getChannels()][bufferSize];
        device.requestPlayBack(0, source.getAudioFormat().getChannels(), (int)stream.getFormat().getSampleRate(), bufferSize, -1);
        int amount = source.readSamples(buffer);
        while (amount > 0) {
            boolean xrun;
            if (amount < bufferSize) {
                int chan = 0;
                while (chan < buffer.length) {
                    Arrays.fill(buffer[chan], amount, bufferSize, 0.0f);
                    ++chan;
                }
            }
            boolean bl = xrun = !device.play(buffer);
            if (xrun) {
                Debug.warn("Audio device overrun", new Object[0]);
            }
            amount = source.readSamples(buffer);
        }
        device.releasePlayBack();
        stream.close();
    }
}

