/*
 * Decompiled with CFR 0.152.
 */
package org.kc7bfi.jflac.sound.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import org.kc7bfi.jflac.Constants;
import org.kc7bfi.jflac.FLACDecoder;
import org.kc7bfi.jflac.io.BitInputStream;
import org.kc7bfi.jflac.io.BitOutputStream;
import org.kc7bfi.jflac.metadata.StreamInfo;
import org.kc7bfi.jflac.sound.spi.FlacAudioFormat;
import org.kc7bfi.jflac.sound.spi.FlacFileFormatType;

public class FlacAudioFileReader
extends AudioFileReader {
    private static final boolean DEBUG = false;
    private FLACDecoder decoder;
    private StreamInfo streamInfo;

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream, (int)file.length());
            return audioFileFormat;
        }
        finally {
            inputStream.close();
        }
    }

    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = url.openStream();
        try {
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream);
            return audioFileFormat;
        }
        finally {
            inputStream.close();
        }
    }

    public AudioFileFormat getAudioFileFormat(InputStream stream) throws UnsupportedAudioFileException, IOException {
        return this.getAudioFileFormat(stream, -1);
    }

    protected AudioFileFormat getAudioFileFormat(InputStream bitStream, int mediaLength) throws UnsupportedAudioFileException, IOException {
        FlacAudioFormat format;
        try {
            this.decoder = new FLACDecoder(bitStream);
            this.streamInfo = this.decoder.readStreamInfo();
            if (this.streamInfo == null) {
                throw new UnsupportedAudioFileException("No StreamInfo found");
            }
            format = new FlacAudioFormat(this.streamInfo);
        }
        catch (IOException ioe) {
            throw new UnsupportedAudioFileException(ioe.getMessage());
        }
        return new AudioFileFormat(FlacFileFormatType.FLAC, format, -1);
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream inputStream = new FileInputStream(file);
        try {
            return this.getAudioInputStream(inputStream, (int)file.length());
        }
        catch (UnsupportedAudioFileException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
        catch (IOException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
    }

    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = url.openStream();
        try {
            return this.getAudioInputStream(inputStream);
        }
        catch (UnsupportedAudioFileException e) {
            inputStream.close();
            throw e;
        }
        catch (IOException e) {
            inputStream.close();
            throw e;
        }
    }

    public AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        return this.getAudioInputStream(stream, -1);
    }

    protected AudioInputStream getAudioInputStream(InputStream inputStream, int medialength) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream, medialength);
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        BitOutputStream bitOutStream = new BitOutputStream(byteOutStream);
        bitOutStream.writeByteBlock(Constants.STREAM_SYNC_STRING, Constants.STREAM_SYNC_STRING.length);
        this.streamInfo.write(bitOutStream, false);
        BitInputStream bis = this.decoder.getBitInputStream();
        int bytesLeft = bis.getInputBytesUnconsumed();
        byte[] b = new byte[bytesLeft];
        bis.readByteBlockAlignedNoCRC(b, bytesLeft);
        byteOutStream.write(b);
        ByteArrayInputStream byteInStream = new ByteArrayInputStream(byteOutStream.toByteArray());
        SequenceInputStream sequenceInputStream = new SequenceInputStream(byteInStream, inputStream);
        return new AudioInputStream(sequenceInputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }
}

