/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.sbr2;

import java.util.Arrays;
import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.SampleFrequency;
import net.sourceforge.jaad.aac.sbr2.SBRConstants;
import net.sourceforge.jaad.aac.sbr2.SBRHeader;

class FrequencyTables
implements SBRConstants {
    private static final int[] MFT_START_MIN = new int[]{7, 7, 10, 11, 12, 16, 16, 17, 24};
    private static final int[] MFT_STOP_MIN = new int[]{13, 15, 20, 21, 23, 32, 32, 35, 48};
    private static final int[] MFT_SF_OFFSETS;
    private static final int[][] MFT_START_OFFSETS;
    private static final int[][] MFT_STOP_OFFSETS;
    private static final int[] MFT_INPUT1;
    private static final float[] MFT_INPUT2;
    private static final float[] LIM_BANDS_PER_OCTAVE_POW;
    private static final float GOAL_SB_FACTOR = 2048000.0f;
    int k0;
    int k2;
    private int[] mft;
    private int nMaster;
    private final int[][] fTable;
    private final int[] n = new int[2];
    private int m = 0;
    private int mPrev = 0;
    private int kx = 0;
    private int kxPrev = 0;
    private int[] fNoise;
    int nq;
    private int[] fLim;
    private int nl;
    private int patchCount;
    private final int[] patchSubbands;
    private final int[] patchStartSubband;
    private int[] patchBorders;

    static {
        int[] nArray = new int[9];
        nArray[0] = 5;
        nArray[1] = 5;
        nArray[2] = 4;
        nArray[3] = 4;
        nArray[4] = 4;
        nArray[5] = 3;
        nArray[6] = 2;
        nArray[7] = 1;
        MFT_SF_OFFSETS = nArray;
        int[][] nArrayArray = new int[6][];
        int[] nArray2 = new int[16];
        nArray2[0] = -8;
        nArray2[1] = -7;
        nArray2[2] = -6;
        nArray2[3] = -5;
        nArray2[4] = -4;
        nArray2[5] = -3;
        nArray2[6] = -2;
        nArray2[7] = -1;
        nArray2[9] = 1;
        nArray2[10] = 2;
        nArray2[11] = 3;
        nArray2[12] = 4;
        nArray2[13] = 5;
        nArray2[14] = 6;
        nArray2[15] = 7;
        nArrayArray[0] = nArray2;
        int[] nArray3 = new int[16];
        nArray3[0] = -5;
        nArray3[1] = -4;
        nArray3[2] = -3;
        nArray3[3] = -2;
        nArray3[4] = -1;
        nArray3[6] = 1;
        nArray3[7] = 2;
        nArray3[8] = 3;
        nArray3[9] = 4;
        nArray3[10] = 5;
        nArray3[11] = 6;
        nArray3[12] = 7;
        nArray3[13] = 9;
        nArray3[14] = 11;
        nArray3[15] = 13;
        nArrayArray[1] = nArray3;
        int[] nArray4 = new int[16];
        nArray4[0] = -5;
        nArray4[1] = -3;
        nArray4[2] = -2;
        nArray4[3] = -1;
        nArray4[5] = 1;
        nArray4[6] = 2;
        nArray4[7] = 3;
        nArray4[8] = 4;
        nArray4[9] = 5;
        nArray4[10] = 6;
        nArray4[11] = 7;
        nArray4[12] = 9;
        nArray4[13] = 11;
        nArray4[14] = 13;
        nArray4[15] = 16;
        nArrayArray[2] = nArray4;
        int[] nArray5 = new int[16];
        nArray5[0] = -6;
        nArray5[1] = -4;
        nArray5[2] = -2;
        nArray5[3] = -1;
        nArray5[5] = 1;
        nArray5[6] = 2;
        nArray5[7] = 3;
        nArray5[8] = 4;
        nArray5[9] = 5;
        nArray5[10] = 6;
        nArray5[11] = 7;
        nArray5[12] = 9;
        nArray5[13] = 11;
        nArray5[14] = 13;
        nArray5[15] = 16;
        nArrayArray[3] = nArray5;
        int[] nArray6 = new int[16];
        nArray6[0] = -4;
        nArray6[1] = -2;
        nArray6[2] = -1;
        nArray6[4] = 1;
        nArray6[5] = 2;
        nArray6[6] = 3;
        nArray6[7] = 4;
        nArray6[8] = 5;
        nArray6[9] = 6;
        nArray6[10] = 7;
        nArray6[11] = 9;
        nArray6[12] = 11;
        nArray6[13] = 13;
        nArray6[14] = 16;
        nArray6[15] = 20;
        nArrayArray[4] = nArray6;
        int[] nArray7 = new int[16];
        nArray7[0] = -2;
        nArray7[1] = -1;
        nArray7[3] = 1;
        nArray7[4] = 2;
        nArray7[5] = 3;
        nArray7[6] = 4;
        nArray7[7] = 5;
        nArray7[8] = 6;
        nArray7[9] = 7;
        nArray7[10] = 9;
        nArray7[11] = 11;
        nArray7[12] = 13;
        nArray7[13] = 16;
        nArray7[14] = 20;
        nArray7[15] = 24;
        nArrayArray[5] = nArray7;
        MFT_START_OFFSETS = nArrayArray;
        MFT_STOP_OFFSETS = new int[][]{{2, 4, 6, 8, 11, 14, 18, 22, 26, 31, 37, 44, 51}, {2, 4, 6, 8, 11, 14, 18, 22, 26, 31, 36, 42, 49}, {2, 4, 6, 9, 11, 14, 17, 21, 25, 29, 34, 39, 44}, {2, 4, 6, 9, 11, 14, 17, 21, 24, 28, 33, 38, 43}, {2, 4, 6, 9, 11, 14, 17, 20, 24, 28, 32, 36, 41}, {2, 4, 6, 8, 10, 12, 14, 17, 20, 23, 26, 29, 32}, {2, 4, 6, 8, 10, 12, 14, 17, 20, 23, 26, 29, 32}, {2, 3, 5, 7, 9, 11, 13, 16, 18, 21, 23, 26, 29}, {1, 2, 3, 4, 6, 7, 8, 9, 11, 12, 13, 15, 16}};
        MFT_INPUT1 = new int[]{12, 10, 8};
        MFT_INPUT2 = new float[]{1.0f, 1.3f};
        LIM_BANDS_PER_OCTAVE_POW = new float[]{1.3271518f, 1.1850928f, 1.1198716f};
    }

    FrequencyTables() {
        this.fTable = new int[2][];
        this.patchSubbands = new int[6];
        this.patchStartSubband = new int[6];
    }

    void calculate(SBRHeader header, int sampleRate) throws AACException {
        this.calculateMFT(header, sampleRate);
        this.calculateFrequencyTables(header);
        this.calculateNoiseTable(header);
        this.calculatePatches(sampleRate);
        this.calculateLimiterTable(header);
    }

    private void calculateMFT(SBRHeader header, int sampleRate) throws AACException {
        int sfIndex = SampleFrequency.forFrequency(sampleRate).getIndex();
        int sfOff = MFT_SF_OFFSETS[sfIndex];
        this.k0 = MFT_START_MIN[sfIndex] + MFT_START_OFFSETS[sfOff][header.getStartFrequency(false)];
        int stop = header.getStopFrequency(false);
        int x = stop == 15 ? 3 * this.k0 : (stop == 14 ? 2 * this.k0 : MFT_STOP_MIN[sfIndex] + MFT_STOP_OFFSETS[sfOff][header.getStopFrequency(false) - 1]);
        this.k2 = Math.min(64, x);
        if (this.k0 >= this.k2) {
            throw new AACException("SBR: MFT borders out of range: lower=" + this.k0 + ", higher=" + this.k2);
        }
        int max = sampleRate == 44100 ? 35 : (sampleRate >= 48000 ? 32 : 48);
        if (this.k2 - this.k0 > max) {
            throw new AACException("SBR: too many subbands: " + (this.k2 - this.k0) + ", maximum number for samplerate " + sampleRate + ": " + max);
        }
        if (header.getFrequencyScale(false) == 0) {
            this.calculateMFT1(header, this.k0, this.k2);
        } else {
            this.calculateMFT2(header, this.k0, this.k2);
        }
        if (header.getXOverBand(false) >= this.nMaster) {
            throw new AACException("SBR: illegal length of master frequency table: " + this.nMaster + ", xOverBand: " + header.getXOverBand(false));
        }
    }

    private void calculateMFT1(SBRHeader header, int k0, int k2) throws AACException {
        int dk;
        if (header.isAlterScale(false)) {
            dk = 2;
            this.nMaster = 2 * Math.round((float)(k2 - k0) / 4.0f);
        } else {
            dk = 1;
            this.nMaster = 2 * (int)((float)(k2 - k0) / 2.0f);
        }
        if (this.nMaster <= 0) {
            throw new AACException("SBR: illegal number of bands for master frequency table: " + this.nMaster);
        }
        int k2Achieved = k0 + this.nMaster * dk;
        int k2Diff = k2 - k2Achieved;
        int[] vDk = new int[this.nMaster];
        Arrays.fill(vDk, dk);
        if (k2Diff != 0) {
            int incr = k2Diff > 0 ? -1 : 1;
            int k = k2Diff > 0 ? this.nMaster - 1 : 0;
            while (k2Diff != 0) {
                int n = k;
                vDk[n] = vDk[n] - incr;
                k += incr;
                k2Diff += incr;
            }
        }
        this.mft = new int[this.nMaster + 1];
        this.mft[0] = k0;
        int i = 1;
        while (i <= this.nMaster) {
            this.mft[i] = this.mft[i - 1] + vDk[i - 1];
            ++i;
        }
    }

    private void calculateMFT2(SBRHeader header, int k0, int k2) throws AACException {
        float pow2;
        float pow1;
        int k1;
        boolean twoRegions;
        int bands = MFT_INPUT1[header.getFrequencyScale(false) - 1];
        float warp = MFT_INPUT2[header.isAlterScale(false) ? 1 : 0];
        float div1 = (float)k2 / (float)k0;
        if ((double)div1 > 2.2449) {
            twoRegions = true;
            k1 = 2 * k0;
        } else {
            twoRegions = false;
            k1 = k2;
        }
        float div2 = (float)k1 / (float)k0;
        float log = (float)Math.log(div2) / 1.3862944f;
        int bandCount0 = 2 * Math.round((float)bands * log);
        if (bandCount0 <= 0) {
            throw new AACException("SBR: illegal band count for master frequency table: " + bandCount0);
        }
        int[] vDk0 = new int[bandCount0];
        int i = 0;
        while (i < bandCount0) {
            pow1 = (float)Math.pow(div2, (float)(i + 1) / (float)bandCount0);
            pow2 = (float)Math.pow(div2, (float)i / (float)bandCount0);
            vDk0[i] = Math.round((float)k0 * pow1) - Math.round((float)k0 * pow2);
            if (vDk0[i] <= 0) {
                throw new AACException("SBR: illegal value in master frequency table: " + vDk0[i]);
            }
            ++i;
        }
        Arrays.sort(vDk0);
        int[] vk0 = new int[bandCount0 + 1];
        vk0[0] = k0;
        int i2 = 1;
        while (i2 <= bandCount0) {
            vk0[i2] = vk0[i2 - 1] + vDk0[i2 - 1];
            ++i2;
        }
        if (twoRegions) {
            div1 = (float)k2 / (float)k1;
            log = (float)Math.log(div1);
            int bandCount1 = 2 * (int)Math.round((double)((float)bands * log) / (1.3862943611198906 * (double)warp));
            int[] vDk1 = new int[bandCount1];
            int min = -1;
            int i3 = 0;
            while (i3 < bandCount1) {
                pow1 = (float)Math.pow(div1, (float)(i3 + 1) / (float)bandCount1);
                pow2 = (float)Math.pow(div1, (float)i3 / (float)bandCount1);
                vDk1[i3] = Math.round((float)k1 * pow1) - Math.round((float)k1 * pow2);
                if (min < 0 || vDk1[i3] < min) {
                    min = vDk1[i3];
                } else if (vDk1[i3] <= 0) {
                    throw new AACException("SBR: illegal value in master frequency table: " + vDk1[i3]);
                }
                ++i3;
            }
            if (min < vDk0[vDk0.length - 1]) {
                Arrays.sort(vDk1);
                int change = vDk0[vDk0.length - 1] - vDk1[0];
                int x = (int)((double)vDk1[bandCount1 - 1] - (double)vDk1[0] / 2.0);
                if (change > x) {
                    change = x;
                }
                vDk1[0] = vDk1[0] + change;
                int n = bandCount1 - 1;
                vDk1[n] = vDk1[n] - change;
            }
            Arrays.sort(vDk1);
            int[] vk1 = new int[bandCount1 + 1];
            vk1[0] = k1;
            int i4 = 1;
            while (i4 <= bandCount1) {
                vk1[i4] = vk1[i4 - 1] + vDk1[i4 - 1];
                ++i4;
            }
            this.nMaster = bandCount0 + bandCount1;
            this.mft = new int[this.nMaster + 1];
            System.arraycopy(vk0, 0, this.mft, 0, bandCount0 + 1);
            System.arraycopy(vk1, 1, this.mft, bandCount0 + 1, bandCount1);
        } else {
            this.nMaster = bandCount0;
            this.mft = new int[this.nMaster + 1];
            System.arraycopy(vk0, 0, this.mft, 0, this.nMaster + 1);
        }
    }

    private void calculateFrequencyTables(SBRHeader header) throws AACException {
        int xover = header.getXOverBand(false);
        this.n[1] = this.getNMaster() - xover;
        this.fTable[1] = new int[this.n[1] + 1];
        System.arraycopy(this.mft, xover, this.fTable[1], 0, this.n[1] + 1);
        this.kxPrev = this.kx;
        this.kx = this.fTable[1][0];
        this.mPrev = this.m;
        this.m = this.fTable[1][this.getN(1)] - this.kx;
        if (this.kx > 32) {
            throw new AACException("SBR: start frequency border out of range: " + this.kx);
        }
        if (this.kx + this.m > 64) {
            throw new AACException("SBR: stop frequency border out of range: " + (this.kx + this.m));
        }
        int half = (int)((double)this.n[1] / 2.0);
        this.n[0] = half + (this.n[1] - 2 * half);
        this.fTable[0] = new int[this.n[0] + 1];
        this.fTable[0][0] = this.fTable[1][0];
        int div = this.n[1] & 1;
        int i = 1;
        while (i <= this.n[0]) {
            this.fTable[0][i] = this.fTable[1][2 * i - div];
            ++i;
        }
    }

    private void calculateNoiseTable(SBRHeader header) throws AACException {
        float log = (float)Math.log((float)this.k2 / (float)this.kx) / 0.6931472f;
        int x = Math.round((float)header.getNoiseBands(false) * log);
        this.nq = Math.max(1, x);
        if (this.nq > 5) {
            throw new AACException("SBR: too many noise floor scalefactors: " + this.nq);
        }
        this.fNoise = new int[this.nq + 1];
        this.fNoise[0] = this.fTable[0][0];
        int i = 0;
        int k = 1;
        while (k <= this.nq) {
            i += (int)((float)(this.n[0] - i) / (float)(this.nq + 1 - k));
            this.fNoise[k] = this.fTable[0][i];
            ++k;
        }
    }

    private void calculatePatches(int sampleRate) throws AACException {
        int sb;
        int k;
        int msb = this.k0;
        int usb = this.kx;
        this.patchCount = 0;
        int goalSb = Math.round(2048000.0f / (float)sampleRate);
        if (goalSb < this.kx + this.m) {
            k = 0;
            int i = 0;
            while (this.mft[i] < goalSb) {
                k = i + 1;
                ++i;
            }
        } else {
            k = this.nMaster;
        }
        do {
            int odd;
            int j = k + 1;
            while ((sb = this.mft[--j]) > this.k0 - 1 + msb - (odd = sb - 2 + this.k0 & 1)) {
            }
            this.patchSubbands[this.patchCount] = Math.max(sb - usb, 0);
            this.patchStartSubband[this.patchCount] = this.k0 - odd - this.patchSubbands[this.patchCount];
            if (this.patchSubbands[this.patchCount] > 0) {
                usb = sb;
                msb = sb;
                ++this.patchCount;
            } else {
                msb = this.kx;
            }
            if (this.mft[k] - sb >= 3) continue;
            k = this.nMaster;
        } while (sb != this.kx + this.m);
        if (this.patchSubbands[this.patchCount - 1] < 3 && this.patchCount > 1) {
            --this.patchCount;
        }
        if (this.patchCount > 5) {
            throw new AACException("SBR: too many patches: " + this.patchCount);
        }
    }

    private void calculateLimiterTable(SBRHeader header) throws AACException {
        int bands = header.getLimiterBands();
        if (bands == 0) {
            this.fLim = new int[]{this.fTable[0][0], this.fTable[0][this.n[0]]};
            this.nl = 1;
            this.patchBorders = new int[0];
        } else {
            float limBandsPerOctaveWarped = LIM_BANDS_PER_OCTAVE_POW[header.getLimiterBands() - 1];
            this.patchBorders = new int[this.patchCount + 1];
            this.patchBorders[0] = this.kx;
            int i = 1;
            while (i <= this.patchCount) {
                this.patchBorders[i] = this.patchBorders[i - 1] + this.patchSubbands[i - 1];
                ++i;
            }
            int[] limTable = new int[this.n[0] + this.patchCount];
            System.arraycopy(this.fTable[0], 0, limTable, 0, this.n[0] + 1);
            if (this.patchCount > 1) {
                System.arraycopy(this.patchBorders, 1, limTable, this.n[0] + 1, this.patchCount - 1);
            }
            Arrays.sort(limTable);
            int in = 1;
            int out = 0;
            int lims = this.n[0] + this.patchCount - 1;
            while (out < lims) {
                if ((float)limTable[in] >= (float)limTable[out] * limBandsPerOctaveWarped) {
                    limTable[++out] = limTable[in++];
                    continue;
                }
                if (limTable[in] == limTable[out] || !this.inArray(this.patchBorders, limTable[in])) {
                    ++in;
                    --lims;
                    continue;
                }
                if (!this.inArray(this.patchBorders, limTable[out])) {
                    limTable[out] = limTable[in++];
                    --lims;
                    continue;
                }
                limTable[++out] = limTable[in++];
            }
            this.fLim = new int[lims + 1];
            System.arraycopy(limTable, 0, this.fLim, 0, lims + 1);
            this.nl = lims;
        }
    }

    private boolean inArray(int[] a, int x) {
        boolean found = false;
        int i = 0;
        while (!found && i < a.length) {
            if (a[i] == x) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    public int getK0() {
        return this.k0;
    }

    public int getK2() {
        return this.k2;
    }

    public int[] getMFT() {
        return this.mft;
    }

    public int getNMaster() {
        return this.nMaster;
    }

    public int[] getFrequencyTable(int i) {
        return this.fTable[i];
    }

    public int getN(int i) {
        return this.n[i];
    }

    public int[] getN() {
        return this.n;
    }

    public int getKx(boolean previous) {
        return previous ? this.kxPrev : this.kx;
    }

    public int getM(boolean previous) {
        return previous ? this.mPrev : this.m;
    }

    public int[] getNoiseTable() {
        return this.fNoise;
    }

    public int getNq() {
        return this.nq;
    }

    public int getPatchCount() {
        return this.patchCount;
    }

    public int[] getPatchSubbands() {
        return this.patchSubbands;
    }

    public int[] getPatchStartSubband() {
        return this.patchStartSubband;
    }

    public int[] getPatchBorders() {
        return this.patchBorders;
    }

    public int[] getLimiterTable() {
        return this.fLim;
    }

    public int getNl() {
        return this.nl;
    }
}

