/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.sbr2;

import net.sourceforge.jaad.aac.sbr2.ChannelData;
import net.sourceforge.jaad.aac.sbr2.FrequencyTables;
import net.sourceforge.jaad.aac.sbr2.NoiseTable;
import net.sourceforge.jaad.aac.sbr2.SBRConstants;
import net.sourceforge.jaad.aac.sbr2.SBRHeader;

class HFAdjuster
implements SBRConstants,
NoiseTable {
    private static final float[] LIMITER_GAINS = new float[]{0.70795f, 1.0f, 1.41254f, 1.0E10f};
    private static final float EPSILON = 1.0f;
    private static final float EPSILON_0 = 1.0E-12f;
    private static final double MAX_BOOST = 1.584893192;
    private static final double[] SMOOTHING_FACTORS = new double[]{0.33333333333333, 0.30150283239582, 0.21816949906249, 0.11516383427084, 0.03183050093751};
    private static final int[][] PHI;
    private static final int MAX_GAIN = 100000;

    static {
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[2] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[1] = 1;
        nArray2[3] = -1;
        nArrayArray[1] = nArray2;
        PHI = nArrayArray;
    }

    HFAdjuster() {
    }

    public static void process(SBRHeader header, FrequencyTables tables, ChannelData cd, float[][][] Xhigh, float[][][] Y) {
        Parameter p = HFAdjuster.map(tables, cd);
        float[][] eCurr = HFAdjuster.estimateEnvelopes(header, tables, cd, Xhigh);
        HFAdjuster.calculateGain(header, tables, cd, p, eCurr);
        HFAdjuster.assembleSignals(header, tables, cd, p, Xhigh, Y);
    }

    private static Parameter map(FrequencyTables tables, ChannelData cd) {
        int kx = tables.getKx(false);
        int[] noiseTable = tables.getNoiseTable();
        int[] fHigh = tables.getFrequencyTable(1);
        int nHigh = tables.getN(1);
        int M = tables.getM(false);
        int nq = tables.getNq();
        int le = cd.getEnvCount();
        int lq = cd.getNoiseCount();
        int[] freqRes = cd.getFrequencyResolutions();
        int la = cd.getLa(false);
        float[][] eOrig = cd.getEnvelopeScalefactors();
        float[][] eMapped = new float[le][M];
        float[][] qOrig = cd.getNoiseFloorData();
        float[][] qMapped = new float[le][M];
        boolean[] sinusoidals = cd.getSinusoidals();
        boolean[] sIndexMappedPrev = cd.getSIndexMappedPrevious();
        boolean[][] sIndexMapped = new boolean[le][M];
        boolean[][] sMapped = new boolean[le][M];
        int e = 0;
        while (e < le) {
            int m;
            int fr = freqRes[e];
            int maxI = tables.getN(fr);
            int[] table = tables.getFrequencyTable(fr);
            int i = 0;
            while (i < maxI) {
                m = table[i];
                while (m < table[i + 1]) {
                    eMapped[e][m - kx] = eOrig[e][i];
                    ++m;
                }
                ++i;
            }
            int k = lq > 1 && cd.getTe()[e] >= cd.getTq()[1] ? 1 : 0;
            i = 0;
            while (i < nq) {
                m = noiseTable[i];
                while (m < noiseTable[i + 1]) {
                    qMapped[e][m - kx] = qOrig[k][i];
                    ++m;
                }
                ++i;
            }
            i = 0;
            while (i < nHigh) {
                if (cd.areSinusoidalsPresent()) {
                    m = fHigh[i] + fHigh[i + 1] >> 1;
                    sIndexMapped[e][m - kx] = sinusoidals[i] && (e >= la || sIndexMappedPrev[m - kx]);
                }
                ++i;
            }
            i = 0;
            while (i < maxI) {
                boolean found = false;
                m = table[i];
                while (!found && m < table[i + 1]) {
                    if (sIndexMapped[e][m - kx]) {
                        found = true;
                    }
                    ++m;
                }
                m = table[i];
                while (m < table[i + 1]) {
                    sMapped[e][m - kx] = found;
                    ++m;
                }
                ++i;
            }
            ++e;
        }
        cd.setSIndexMappedPrevious(sIndexMapped[le - 1]);
        Parameter p = new Parameter();
        p.eMapped = eMapped;
        p.qMapped = qMapped;
        p.sIndexMapped = sIndexMapped;
        p.sMapped = sMapped;
        return p;
    }

    private static float[][] estimateEnvelopes(SBRHeader header, FrequencyTables tables, ChannelData cd, float[][][] Xhigh) {
        int[] te = cd.getTe();
        int M = tables.getM(false);
        int kx = tables.getKx(false);
        int le = cd.getEnvCount();
        float[][] eCurr = new float[le][M];
        if (header.interpolateFrequency()) {
            int e = 0;
            while (e < le) {
                float div = te[e + 1] - te[e];
                int iLow = 2 * te[e] + 2;
                int iHigh = 2 * te[e + 1] + 2;
                int m = 0;
                while (m < M) {
                    float sum = 0.0f;
                    int i = iLow;
                    while (i < iHigh) {
                        sum += Xhigh[m + kx][i][0] * Xhigh[m + kx][i][0] + Xhigh[m + kx][i][1] * Xhigh[m + kx][i][1];
                        ++i;
                    }
                    eCurr[e][m] = sum / div;
                    ++m;
                }
                ++e;
            }
        } else {
            int[] n = tables.getN();
            int[] freqRes = cd.getFrequencyResolutions();
            int e = 0;
            while (e < le) {
                int div1 = 2 * (te[e + 1] - te[e]);
                int iLow = 2 * te[e] + 2;
                int iHigh = 2 * te[e + 1] + 2;
                int[] table = tables.getFrequencyTable(freqRes[e + 1]);
                int m = 0;
                while (m < n[freqRes[e + 1]]) {
                    float sum = 0.0f;
                    int div2 = div1 * (table[m + 1] - table[m]);
                    int k = table[m];
                    while (k < table[m + 1]) {
                        int i = iLow;
                        while (i < iHigh) {
                            sum += Xhigh[k][i][0] * Xhigh[k][i][0] + Xhigh[k][i][1] * Xhigh[k][i][1];
                            ++i;
                        }
                        ++k;
                    }
                    sum /= (float)div2;
                    k = table[m];
                    while (k < table[m + 1]) {
                        eCurr[e][k - kx] = sum;
                        ++k;
                    }
                    ++m;
                }
                ++e;
            }
        }
        return eCurr;
    }

    private static void calculateGain(SBRHeader header, FrequencyTables tables, ChannelData cd, Parameter p, float[][] eCurr) {
        int limGain = header.getLimiterGains();
        int M = tables.getM(false);
        int nl = tables.getNl();
        int[] fLim = tables.getLimiterTable();
        int kx = tables.getKx(false);
        int la = cd.getLa(false);
        int laPrevious = cd.getLa(true);
        int le = cd.getEnvCount();
        float[][] Qm = new float[le][M];
        float[][] Sm = new float[le][M];
        float[][] gain = new float[le][M];
        int[] km = new int[M];
        float[] eMappedSum = new float[nl];
        float[][] gTemp = new float[le][nl];
        int e = 0;
        while (e < le) {
            float gMax;
            int i;
            float tmp;
            boolean delta = e != la && e != laPrevious;
            int m = 0;
            while (m < M) {
                tmp = p.eMapped[e][m] / (1.0f + p.qMapped[e][m]);
                Qm[e][m] = (float)Math.sqrt(tmp * p.qMapped[e][m]);
                float f = Sm[e][m] = p.sIndexMapped[e][m] ? (float)Math.sqrt(tmp) : 0.0f;
                gain[e][m] = p.sMapped[e][m] ? (float)Math.sqrt(p.eMapped[e][m] * p.qMapped[e][m] / ((1.0f + eCurr[e][m]) * (1.0f + p.qMapped[e][m]))) : (float)Math.sqrt(p.eMapped[e][m] / ((1.0f + eCurr[e][m]) * (1.0f + (delta ? p.qMapped[e][m] : 0.0f))));
                ++m;
            }
            int k = 0;
            while (k < nl) {
                eMappedSum[k] = 1.0E-12f;
                tmp = 1.0E-12f;
                i = fLim[k] - kx;
                while (i < fLim[k + 1] - kx) {
                    int n = k;
                    eMappedSum[n] = eMappedSum[n] + p.eMapped[e][i];
                    tmp += eCurr[e][i];
                    ++i;
                }
                gTemp[e][k] = (float)Math.sqrt(eMappedSum[k] / tmp) * LIMITER_GAINS[limGain];
                ++k;
            }
            m = 0;
            while (m < M) {
                km[m] = -1;
                i = 0;
                while (km[m] < 0 && i < fLim.length) {
                    if (fLim[i] <= m + kx && fLim[i + 1] > m + kx) {
                        km[m] = i;
                    }
                    ++i;
                }
                gMax = Math.min(gTemp[e][km[m]], 100000.0f);
                Qm[e][m] = Math.min(Qm[e][m], Qm[e][m] * (gMax / gain[e][m]));
                gain[e][m] = Math.min(gain[e][m], gMax);
                ++m;
            }
            k = 0;
            while (k < nl) {
                tmp = 1.0E-12f;
                i = fLim[k] - kx;
                while (i < fLim[k + 1] - kx) {
                    boolean delta2 = Sm[e][i] == 0.0f && delta;
                    tmp += eCurr[e][i] * gain[e][i] * gain[e][i] + Sm[e][i] * Sm[e][i] + (delta2 ? Qm[e][i] * Qm[e][i] : 0.0f);
                    ++i;
                }
                gTemp[e][k] = (float)Math.sqrt(eMappedSum[k] / tmp);
                ++k;
            }
            m = 0;
            while (m < M) {
                gMax = (float)Math.min((double)gTemp[e][km[m]], 1.584893192);
                float[] fArray = Qm[e];
                int n = m;
                fArray[n] = fArray[n] * gMax;
                float[] fArray2 = Sm[e];
                int n2 = m;
                fArray2[n2] = fArray2[n2] * gMax;
                float[] fArray3 = gain[e];
                int n3 = m++;
                fArray3[n3] = fArray3[n3] * gMax;
            }
            ++e;
        }
        p.Qm = Qm;
        p.Sm = Sm;
        p.Glim = gain;
    }

    private static void assembleSignals(SBRHeader header, FrequencyTables tables, ChannelData cd, Parameter p, float[][][] Xhigh, float[][][] Y) {
        int i;
        boolean reset = header.isReset();
        int hSL = header.isSmoothingMode() ? 0 : 4;
        int M = tables.getM(false);
        int le = cd.getEnvCount();
        int lePrev = cd.getEnvCountPrevious();
        int[] te = cd.getTe();
        int la = cd.getLa(false);
        int laPrev = cd.getLa(true);
        int kx = tables.getKx(false);
        int noiseIndex = reset ? 0 : cd.getNoiseIndex();
        int sineIndex = cd.getSineIndex();
        float[][] gTmp = cd.getGTmp();
        float[][] qTmp = cd.getQTmp();
        if (reset) {
            i = 0;
            while (i < hSL) {
                System.arraycopy(gTmp[lePrev - hSL + i], 0, p.Glim[0], 0, M);
                System.arraycopy(qTmp[lePrev - hSL + i], 0, p.Qm[0], 0, M);
                ++i;
            }
        } else if (hSL != 0) {
            i = 0;
            while (i < hSL) {
                System.arraycopy(gTmp[lePrev - hSL + i], 0, gTmp[2 * te[i]], 0, M);
                System.arraycopy(qTmp[lePrev - hSL + i], 0, qTmp[2 * te[i]], 0, M);
                ++i;
            }
        }
        int phiSign = 1 - 2 * (kx & 1);
        int e = 0;
        while (e < le) {
            i = 2 * te[e];
            while (i < 2 * te[e + 1]) {
                int j;
                int idx1;
                int m;
                if (hSL != 0 && e != la && e != laPrev) {
                    m = 0;
                    while (m < M) {
                        idx1 = i + hSL;
                        float gFilt = 0.0f;
                        j = 0;
                        while (j <= hSL) {
                            gFilt = (float)((double)gFilt + (double)gTmp[idx1 - j][m] * SMOOTHING_FACTORS[j]);
                            ++j;
                        }
                        Y[i][m + kx][0] = Xhigh[m + kx][i + 2][0] * gFilt;
                        Y[i][m + kx][1] = Xhigh[m + kx][i + 2][1] * gFilt;
                        ++m;
                    }
                } else {
                    m = 0;
                    while (m < M) {
                        float g_filt = gTmp[i + hSL][m];
                        Y[i][m + kx][0] = Xhigh[m + kx][i + 2][0] * g_filt;
                        Y[i][m + kx][1] = Xhigh[m + kx][i + 2][1] * g_filt;
                        ++m;
                    }
                }
                if (e != la && e != laPrev) {
                    m = 0;
                    while (m < M) {
                        noiseIndex = noiseIndex + 1 & 0x1FF;
                        if (p.Sm[e][m] != 0.0f) {
                            float[] fArray = Y[i][m + kx];
                            fArray[0] = fArray[0] + p.Sm[e][m] * (float)PHI[0][sineIndex];
                            float[] fArray2 = Y[i][m + kx];
                            fArray2[1] = fArray2[1] + p.Sm[e][m] * (float)(PHI[1][sineIndex] * phiSign);
                        } else {
                            float qFilt;
                            if (hSL != 0) {
                                idx1 = i + hSL;
                                qFilt = 0.0f;
                                j = 0;
                                while (j <= hSL) {
                                    qFilt = (float)((double)qFilt + (double)qTmp[idx1 - j][m] * SMOOTHING_FACTORS[j]);
                                    ++j;
                                }
                            } else {
                                qFilt = qTmp[i][m];
                            }
                            float[] fArray = Y[i][m + kx];
                            fArray[0] = fArray[0] + qFilt * NOISE_TABLE[noiseIndex][0];
                            float[] fArray3 = Y[i][m + kx];
                            fArray3[1] = fArray3[1] + qFilt * NOISE_TABLE[noiseIndex][1];
                        }
                        phiSign = -phiSign;
                        ++m;
                    }
                } else {
                    noiseIndex = noiseIndex + M & 0x1FF;
                    m = 0;
                    while (m < M) {
                        float[] fArray = Y[i][m + kx];
                        fArray[0] = fArray[0] + p.Sm[e][m] * (float)PHI[0][sineIndex];
                        float[] fArray4 = Y[i][m + kx];
                        fArray4[1] = fArray4[1] + p.Sm[e][m] * (float)(PHI[1][sineIndex] * phiSign);
                        phiSign = -phiSign;
                        ++m;
                    }
                }
                sineIndex = sineIndex + 1 & 3;
                ++i;
            }
            ++e;
        }
        cd.setNoiseIndex(noiseIndex);
        cd.setSineIndex(sineIndex);
    }

    private static class Parameter {
        float[][] eMapped;
        float[][] qMapped;
        boolean[][] sIndexMapped;
        boolean[][] sMapped;
        float[][] Qm;
        float[][] Sm;
        float[][] Glim;

        private Parameter() {
        }
    }
}

