/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.sbr2;

import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.sbr2.ChannelData;
import net.sourceforge.jaad.aac.sbr2.FrequencyTables;
import net.sourceforge.jaad.aac.sbr2.SBRConstants;

class HFGenerator
implements SBRConstants {
    private static final float RELAX_COEF = 1.000001f;
    private static final int ALPHA_MAX = 16;
    private static final float[][] CHIRP_COEFS = new float[][]{{0.75f, 0.25f}, {0.90625f, 0.09375f}};
    private static final float[][] BW_COEFS = new float[][]{{0.0f, 0.6f, 0.9f, 0.98f}, {0.6f, 0.75f, 0.9f, 0.98f}, {0.0f, 0.75f, 0.9f, 0.98f}, {0.0f, 0.75f, 0.9f, 0.98f}};
    private static final float CHIRP_MIN = 0.015625f;

    HFGenerator() {
    }

    public static void process(FrequencyTables tables, ChannelData cd, float[][][] Xlow, float[][][] Xhigh) throws AACException {
        float[] bwArray = HFGenerator.calculateChirpFactors(tables, cd);
        int k0 = tables.getK0();
        float[][] alpha0 = new float[k0][2];
        float[][] alpha1 = new float[k0][2];
        HFGenerator.calculateIFCoefs(tables, alpha0, alpha1, Xlow);
        int patchCount = tables.getPatchCount();
        int[] patchSubbands = tables.getPatchSubbands();
        int[] patchStartSubband = tables.getPatchStartSubband();
        int kx = tables.getKx(false);
        int m = tables.getM(false);
        int Nq = tables.getNq();
        int[] fNoise = tables.getNoiseTable();
        int[] te = cd.getTe();
        int start = 2 * te[0];
        int end = 2 * te[cd.getEnvCount()];
        float[] alpha = new float[4];
        int k = kx;
        int g = 0;
        int j = 0;
        while (j < patchCount) {
            int x = 0;
            while (x < patchSubbands[j]) {
                int p = patchStartSubband[j] + x;
                while (g <= Nq && k >= fNoise[g]) {
                    ++g;
                }
                if (--g < 0) {
                    throw new AACException("SBR: HFGenerator: no subband found for frequency " + k);
                }
                float square = bwArray[g] * bwArray[g];
                alpha[0] = alpha1[p][0] * square;
                alpha[1] = alpha1[p][1] * square;
                alpha[2] = alpha0[p][0] * bwArray[g];
                alpha[3] = alpha0[p][1] * bwArray[g];
                int l = start;
                while (l < end) {
                    int off = l + 2;
                    Xhigh[k][off][0] = alpha[0] * Xlow[p][off - 2][0] - alpha[1] * Xlow[p][off - 2][1] + alpha[2] * Xlow[p][off - 1][0] - alpha[3] * Xlow[p][off - 1][1] + Xlow[p][off][0];
                    Xhigh[k][off][1] = alpha[0] * Xlow[p][off - 2][1] + alpha[1] * Xlow[p][off - 2][0] + alpha[2] * Xlow[p][off - 1][1] + alpha[3] * Xlow[p][off - 1][0] + Xlow[p][off][1];
                    ++l;
                }
                ++x;
                ++k;
            }
            ++j;
        }
        while (k < m + kx) {
            j = 0;
            while (j < Xhigh[k].length) {
                Xhigh[k][j][0] = 0.0f;
                Xhigh[k][j][1] = 0.0f;
                ++j;
            }
            ++k;
        }
    }

    private static float[] calculateChirpFactors(FrequencyTables tables, ChannelData cd) {
        int nq = tables.getNq();
        int[] invfMode = cd.getInvfMode(false);
        int[] invfModePrevious = cd.getInvfMode(true);
        float[] bwArray = cd.getChirpFactors();
        int i = 0;
        while (i < nq) {
            float tmp = BW_COEFS[invfModePrevious[i]][invfMode[i]];
            float[] chirpCoefs = tmp < bwArray[i] ? CHIRP_COEFS[0] : CHIRP_COEFS[1];
            bwArray[i] = chirpCoefs[0] * tmp + chirpCoefs[1] * bwArray[i];
            if (bwArray[i] < 0.015625f) {
                bwArray[i] = 0.0f;
            }
            ++i;
        }
        return bwArray;
    }

    private static void calculateIFCoefs(FrequencyTables tables, float[][] alpha0, float[][] alpha1, float[][][] Xlow) {
        int k0 = tables.getK0();
        float[] tmp = new float[2];
        int k = 0;
        while (k < k0) {
            float[][][] phi = new float[3][2][2];
            HFGenerator.getCovarianceMatrix(Xlow[k], phi, 0);
            HFGenerator.getCovarianceMatrix(Xlow[k], phi, 1);
            HFGenerator.getCovarianceMatrix(Xlow[k], phi, 2);
            float d = phi[2][1][0] * phi[1][0][0] - (phi[1][1][0] * phi[1][1][0] + phi[1][1][1] * phi[1][1][1]) / 1.000001f;
            if (d == 0.0f) {
                alpha1[k][0] = 0.0f;
                alpha1[k][1] = 0.0f;
            } else {
                tmp[0] = phi[0][0][0] * phi[1][1][0] - phi[0][0][1] * phi[1][1][1] - phi[0][1][0] * phi[1][0][0];
                tmp[1] = phi[0][0][0] * phi[1][1][1] + phi[0][0][1] * phi[1][1][0] - phi[0][1][1] * phi[1][0][0];
                alpha1[k][0] = tmp[0] / d;
                alpha1[k][1] = tmp[1] / d;
            }
            if (phi[1][0][0] == 0.0f) {
                alpha0[k][0] = 0.0f;
                alpha0[k][1] = 0.0f;
            } else {
                tmp[0] = phi[0][0][0] + alpha1[k][0] * phi[1][1][0] + alpha1[k][1] * phi[1][1][1];
                tmp[1] = phi[0][0][1] + alpha1[k][1] * phi[1][1][0] - alpha1[k][0] * phi[1][1][1];
                alpha0[k][0] = -tmp[0] / phi[1][0][0];
                alpha0[k][1] = -tmp[1] / phi[1][0][0];
            }
            if (alpha1[k][0] * alpha1[k][0] + alpha1[k][1] * alpha1[k][1] >= 16.0f || alpha0[k][0] * alpha0[k][0] + alpha0[k][1] * alpha0[k][1] >= 16.0f) {
                alpha1[k][0] = 0.0f;
                alpha1[k][1] = 0.0f;
                alpha0[k][0] = 0.0f;
                alpha0[k][1] = 0.0f;
            }
            ++k;
        }
    }

    private static void getCovarianceMatrix(float[][] x, float[][][] phi, int off) {
        float[] sum = new float[2];
        if (off == 0) {
            int i = 1;
            while (i < 38) {
                sum[0] = sum[0] + (x[i][0] * x[i][0] + x[i][1] * x[i][1]);
                ++i;
            }
            phi[2][1][0] = sum[0] + x[0][0] * x[0][0] + x[0][1] * x[0][1];
            phi[1][0][0] = sum[0] + x[38][0] * x[38][0] + x[38][1] * x[38][1];
        } else {
            int i = 1;
            while (i < 38) {
                sum[0] = sum[0] + (x[i][0] * x[i + off][0] + x[i][1] * x[i + off][1]);
                sum[1] = sum[1] + (x[i][0] * x[i + off][1] - x[i][1] * x[i + off][0]);
                ++i;
            }
            phi[2 - off][1][0] = sum[0] + x[0][0] * x[off][0] + x[0][1] * x[off][1];
            phi[2 - off][1][1] = sum[1] + x[0][0] * x[off][1] - x[0][1] * x[off][0];
            if (off == 1) {
                phi[0][0][0] = sum[0] + x[38][0] * x[39][0] + x[38][1] * x[39][1];
                phi[0][0][1] = sum[1] + x[38][0] * x[39][1] - x[38][1] * x[39][0];
            }
        }
    }
}

