/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.sbr2;

import net.sourceforge.jaad.aac.sbr2.FilterbankTables;
import net.sourceforge.jaad.aac.sbr2.SBRConstants;

class SynthesisFilterbank
implements SBRConstants,
FilterbankTables {
    private final float[][][] COEFS;
    private final float[][] V = new float[2][1280];
    private final float[] g = new float[640];

    SynthesisFilterbank() {
        this.COEFS = new float[64][128][2];
        float fac = 0.015625f;
        int k = 0;
        while (k < 64) {
            int n = 0;
            while (n < 128) {
                double tmp = 0.02454369260617026 * ((double)n + 0.5) * (double)(2 * k - 255);
                this.COEFS[k][n][0] = 0.015625f * (float)Math.cos(tmp);
                this.COEFS[k][n][1] = 0.015625f * (float)Math.sin(tmp);
                ++n;
            }
            ++k;
        }
    }

    public void process(float[][][] in, float[] out, int ch) {
        float[] v = this.V[ch];
        int off = 0;
        int l = 0;
        while (l < 32) {
            int k;
            System.arraycopy(v, 0, v, 128, 1152);
            int n = 0;
            while (n < 128) {
                v[n] = 0.0f;
                k = 0;
                while (k < 64) {
                    int n2 = n;
                    v[n2] = v[n2] + in[k][l][0] * this.COEFS[k][n][0];
                    int n3 = n;
                    v[n3] = v[n3] - in[k][l][1] * this.COEFS[k][n][1];
                    ++k;
                }
                ++n;
            }
            n = 0;
            while (n < 5) {
                k = 0;
                while (k < 64) {
                    this.g[128 * n + k] = v[256 * n + k];
                    this.g[128 * n + 64 + k] = v[256 * n + 192 + k];
                    ++k;
                }
                ++n;
            }
            n = 0;
            while (n <= 639) {
                int n4 = n;
                this.g[n4] = this.g[n4] * (float)WINDOW[n];
                ++n;
            }
            k = 0;
            while (k <= 63) {
                out[off] = this.g[k];
                n = 1;
                while (n <= 9) {
                    int n5 = off;
                    out[n5] = out[n5] + this.g[64 * n + k];
                    ++n;
                }
                ++off;
                ++k;
            }
            ++l;
        }
    }
}

