/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.tools;

import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.SampleFrequency;
import net.sourceforge.jaad.aac.syntax.BitStream;
import net.sourceforge.jaad.aac.syntax.Constants;
import net.sourceforge.jaad.aac.syntax.ICSInfo;
import net.sourceforge.jaad.aac.syntax.ICStream;
import net.sourceforge.jaad.aac.tools.TNSTables;

public class TNS
implements Constants,
TNSTables {
    private static final int TNS_MAX_ORDER = 20;
    private static final int[] SHORT_BITS = new int[]{1, 4, 3};
    private static final int[] LONG_BITS = new int[]{2, 6, 5};
    private int[] nFilt = new int[8];
    private int[][] length = new int[8][4];
    private int[][] order;
    private boolean[][] direction = new boolean[8][4];
    private float[][][] coef;

    public TNS() {
        this.order = new int[8][4];
        this.coef = new float[8][4][20];
    }

    public void decode(BitStream in, ICSInfo info) throws AACException {
        int windowCount = info.getWindowCount();
        int[] bits = info.isEightShortFrame() ? SHORT_BITS : LONG_BITS;
        int w = 0;
        while (w < windowCount) {
            this.nFilt[w] = in.readBits(bits[0]);
            if (this.nFilt[w] != 0) {
                int coefRes = in.readBit();
                int filt = 0;
                while (filt < this.nFilt[w]) {
                    this.length[w][filt] = in.readBits(bits[1]);
                    this.order[w][filt] = in.readBits(bits[2]);
                    if (this.order[w][filt] > 20) {
                        throw new AACException("TNS filter out of range: " + this.order[w][filt]);
                    }
                    if (this.order[w][filt] != 0) {
                        this.direction[w][filt] = in.readBool();
                        int coefCompress = in.readBit();
                        int coefLen = coefRes + 3 - coefCompress;
                        int tmp = 2 * coefCompress + coefRes;
                        int i = 0;
                        while (i < this.order[w][filt]) {
                            this.coef[w][filt][i] = TNS_TABLES[tmp][in.readBits(coefLen)];
                            ++i;
                        }
                    }
                    ++filt;
                }
            }
            ++w;
        }
    }

    public void process(ICStream ics, float[] spec, SampleFrequency sf, boolean decode) {
    }
}

