/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.mp4;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.jaad.mp4.MP4Exception;
import net.sourceforge.jaad.mp4.MP4InputStream;
import net.sourceforge.jaad.mp4.api.Brand;
import net.sourceforge.jaad.mp4.api.Movie;
import net.sourceforge.jaad.mp4.boxes.Box;
import net.sourceforge.jaad.mp4.boxes.BoxFactory;
import net.sourceforge.jaad.mp4.boxes.impl.FileTypeBox;
import net.sourceforge.jaad.mp4.boxes.impl.ProgressiveDownloadInformationBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MP4Container {
    private final MP4InputStream in;
    private final List<Box> boxes;
    private Brand major;
    private Brand minor;
    private Brand[] compatible;
    private FileTypeBox ftyp;
    private ProgressiveDownloadInformationBox pdin;
    private Box moov;
    private Movie movie;

    static {
        Handler h;
        Logger log = Logger.getLogger("MP4 API");
        Handler[] handlerArray = log.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            h = handlerArray[n2];
            log.removeHandler(h);
            ++n2;
        }
        log.setLevel(Level.WARNING);
        h = new ConsoleHandler();
        h.setLevel(Level.ALL);
        log.addHandler(h);
    }

    public MP4Container(InputStream in) throws IOException {
        this.in = new MP4InputStream(in);
        this.boxes = new ArrayList<Box>();
        this.readContent();
    }

    public MP4Container(RandomAccessFile in) throws IOException {
        this.in = new MP4InputStream(in);
        this.boxes = new ArrayList<Box>();
        this.readContent();
    }

    private void readContent() throws IOException {
        Box box = null;
        boolean moovFound = false;
        while (this.in.hasLeft()) {
            box = BoxFactory.parseBox(null, this.in);
            if (this.boxes.isEmpty() && box.getType() != 1718909296L) {
                throw new MP4Exception("no MP4 signature found");
            }
            this.boxes.add(box);
            long type = box.getType();
            if (type == 1718909296L) {
                if (this.ftyp != null) continue;
                this.ftyp = (FileTypeBox)box;
                continue;
            }
            if (type == 1836019574L) {
                if (this.movie == null) {
                    this.moov = box;
                }
                moovFound = true;
                continue;
            }
            if (type == 1885628782L) {
                if (this.pdin != null) continue;
                this.pdin = (ProgressiveDownloadInformationBox)box;
                continue;
            }
            if (type != 1835295092L) continue;
            if (moovFound) break;
            if (this.in.hasRandomAccess()) continue;
            throw new MP4Exception("movie box at end of file, need random access");
        }
    }

    public Brand getMajorBrand() {
        if (this.major == null) {
            this.major = Brand.forID(this.ftyp.getMajorBrand());
        }
        return this.major;
    }

    public Brand getMinorBrand() {
        if (this.minor == null) {
            this.minor = Brand.forID(this.ftyp.getMajorBrand());
        }
        return this.minor;
    }

    public Brand[] getCompatibleBrands() {
        if (this.compatible == null) {
            String[] s = this.ftyp.getCompatibleBrands();
            this.compatible = new Brand[s.length];
            int i = 0;
            while (i < s.length) {
                this.compatible[i] = Brand.forID(s[i]);
                ++i;
            }
        }
        return this.compatible;
    }

    public Movie getMovie() {
        if (this.moov == null) {
            return null;
        }
        if (this.movie == null) {
            this.movie = new Movie(this.moov, this.in);
        }
        return this.movie;
    }

    public List<Box> getBoxes() {
        return Collections.unmodifiableList(this.boxes);
    }
}

