/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.mp4.boxes.impl.fd;

import java.io.IOException;
import net.sourceforge.jaad.mp4.MP4InputStream;
import net.sourceforge.jaad.mp4.boxes.FullBox;

public class FDSessionGroupBox
extends FullBox {
    private long[][] groupIDs;
    private long[][] hintTrackIDs;

    public FDSessionGroupBox() {
        super("FD Session Group Box");
    }

    public void decode(MP4InputStream in) throws IOException {
        super.decode(in);
        int sessionGroups = (int)in.readBytes(2);
        this.groupIDs = new long[sessionGroups][];
        this.hintTrackIDs = new long[sessionGroups][];
        int i = 0;
        while (i < sessionGroups) {
            int entryCount = in.read();
            this.groupIDs[i] = new long[entryCount];
            int j = 0;
            while (j < entryCount) {
                this.groupIDs[i][j] = in.readBytes(4);
                ++j;
            }
            int channelsInSessionGroup = (int)in.readBytes(2);
            this.hintTrackIDs[i] = new long[channelsInSessionGroup];
            j = 0;
            while (j < channelsInSessionGroup) {
                this.hintTrackIDs[i][j] = in.readBytes(4);
                ++j;
            }
            ++i;
        }
    }

    public long[][] getGroupIDs() {
        return this.groupIDs;
    }

    public long[][] getHintTrackIDs() {
        return this.hintTrackIDs;
    }
}

