/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.mp4.boxes.impl.sampleentries.codec;

import java.io.IOException;
import net.sourceforge.jaad.mp4.MP4InputStream;
import net.sourceforge.jaad.mp4.boxes.impl.sampleentries.codec.CodecSpecificBox;

public class AVCSpecificBox
extends CodecSpecificBox {
    private int configurationVersion;
    private int profile;
    private int level;
    private int lengthSize;
    private byte profileCompatibility;
    private byte[][] sequenceParameterSetNALUnit;
    private byte[][] pictureParameterSetNALUnit;

    public AVCSpecificBox() {
        super("AVC Specific Box");
    }

    public void decode(MP4InputStream in) throws IOException {
        int len;
        this.configurationVersion = in.read();
        this.profile = in.read();
        this.profileCompatibility = (byte)in.read();
        this.level = in.read();
        this.lengthSize = (in.read() & 3) + 1;
        int sequenceParameterSets = in.read() & 0x1F;
        this.sequenceParameterSetNALUnit = new byte[sequenceParameterSets][];
        int i = 0;
        while (i < sequenceParameterSets) {
            len = (int)in.readBytes(2);
            this.sequenceParameterSetNALUnit[i] = new byte[len];
            in.readBytes(this.sequenceParameterSetNALUnit[i]);
            ++i;
        }
        int pictureParameterSets = in.read();
        this.pictureParameterSetNALUnit = new byte[pictureParameterSets][];
        int i2 = 0;
        while (i2 < pictureParameterSets) {
            len = (int)in.readBytes(2);
            this.pictureParameterSetNALUnit[i2] = new byte[len];
            in.readBytes(this.pictureParameterSetNALUnit[i2]);
            ++i2;
        }
    }

    public int getConfigurationVersion() {
        return this.configurationVersion;
    }

    public int getProfile() {
        return this.profile;
    }

    public byte getProfileCompatibility() {
        return this.profileCompatibility;
    }

    public int getLevel() {
        return this.level;
    }

    public int getLengthSize() {
        return this.lengthSize;
    }

    public byte[][] getSequenceParameterSetNALUnits() {
        return this.sequenceParameterSetNALUnit;
    }

    public byte[][] getPictureParameterSetNALUnits() {
        return this.pictureParameterSetNALUnit;
    }
}

