/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.spi.javasound;

class CircularBuffer {
    private static final int BUFFER_SIZE = 327670;
    private final byte[] data;
    private final Trigger trigger;
    private long readPos;
    private long writePos;
    private boolean open;

    CircularBuffer(Trigger trigger) {
        this.trigger = trigger;
        this.data = new byte[327670];
        this.readPos = 0L;
        this.writePos = 0L;
        this.open = true;
    }

    public void close() {
        this.open = false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public int availableRead() {
        return (int)(this.writePos - this.readPos);
    }

    public int availableWrite() {
        return 327670 - this.availableRead();
    }

    private int getReadPos() {
        return (int)(this.readPos % 327670L);
    }

    private int getWritePos() {
        return (int)(this.writePos % 327670L);
    }

    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int read(byte[] b, int off, int len) {
        if (!this.isOpen()) {
            if (this.availableRead() > 0) {
                len = Math.min(len, this.availableRead());
            } else {
                return -1;
            }
        }
        var4_4 = this;
        synchronized (var4_4) {
            if (this.trigger != null && this.availableRead() < len) {
                this.trigger.execute();
            }
            remaining = len = Math.min(this.availableRead(), len);
            ** GOTO lbl30
            {
                try {
                    this.wait();
                }
                catch (InterruptedException var6_6) {
                    // empty catch block
                }
                do {
                    if (this.availableRead() == 0) continue block5;
                    available = Math.min(this.availableRead(), remaining);
                    while (available > 0) {
                        toRead = Math.min(available, 327670 - this.getReadPos());
                        System.arraycopy(this.data, this.getReadPos(), b, off, toRead);
                        this.readPos += (long)toRead;
                        off += toRead;
                        available -= toRead;
                        remaining -= toRead;
                    }
                    this.notifyAll();
lbl30:
                    // 2 sources

                } while (remaining > 0);
            }
            return len;
        }
    }

    public int write(byte[] b) {
        return this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int write(byte[] b, int off, int len) {
        var4_4 = this;
        synchronized (var4_4) {
            remaining = len;
            ** GOTO lbl23
            {
                try {
                    this.wait();
                }
                catch (InterruptedException var6_6) {
                    // empty catch block
                }
                do {
                    if (this.availableWrite() == 0) continue block5;
                    available = Math.min(this.availableWrite(), remaining);
                    while (available > 0) {
                        toWrite = Math.min(available, 327670 - this.getWritePos());
                        System.arraycopy(b, off, this.data, this.getWritePos(), toWrite);
                        this.writePos += (long)toWrite;
                        off += toWrite;
                        available -= toWrite;
                        remaining -= toWrite;
                    }
                    this.notifyAll();
lbl23:
                    // 2 sources

                } while (remaining > 0);
            }
            return len;
        }
    }

    static interface Trigger {
        public void execute();
    }
}

