/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.file.TAudioFileFormat;
import org.tritonus.share.sampled.file.TAudioFileReader;

public class AuAudioFileReader
extends TAudioFileReader {
    private static final int READ_LIMIT = 1000;

    public AuAudioFileReader() {
        super(1000);
    }

    /*
     * Unable to fully structure code
     */
    private static String readDescription(DataInputStream dis, int len) throws IOException {
        c = -1;
        ret = "";
        if (true) ** GOTO lbl7
        do {
            ret = String.valueOf(ret) + (char)c;
            --len;
lbl7:
            // 2 sources

            if (len <= 0) break;
            v0 = dis.readByte();
            c = v0;
        } while (v0 != 0);
        if (len > 1 && c == 0) {
            dis.skip(len - 1);
        }
        return ret;
    }

    protected AudioFileFormat getAudioFileFormat(InputStream inputStream, long lFileSizeInBytes) throws UnsupportedAudioFileException, IOException {
        DataInputStream dataInputStream;
        int nMagic;
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("AuAudioFileReader.getAudioFileFormat(InputStream, long): begin");
        }
        if ((nMagic = (dataInputStream = new DataInputStream(inputStream)).readInt()) != 779316836) {
            throw new UnsupportedAudioFileException("not an AU file: wrong header magic");
        }
        int nDataOffset = dataInputStream.readInt();
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("AuAudioFileReader.getAudioFileFormat(): data offset: " + nDataOffset);
        }
        if (nDataOffset < 24) {
            throw new UnsupportedAudioFileException("not an AU file: data offset must be 24 or greater");
        }
        int nDataLength = dataInputStream.readInt();
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("AuAudioFileReader.getAudioFileFormat(): data length: " + nDataLength);
        }
        if (nDataLength < 0 && nDataLength != -1) {
            throw new UnsupportedAudioFileException("not an AU file: data length must be positive, 0 or -1 for unknown");
        }
        AudioFormat.Encoding encoding = null;
        int nSampleSize = 0;
        int nEncoding = dataInputStream.readInt();
        switch (nEncoding) {
            case 1: {
                encoding = AudioFormat.Encoding.ULAW;
                nSampleSize = 8;
                break;
            }
            case 2: {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                nSampleSize = 8;
                break;
            }
            case 3: {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                nSampleSize = 16;
                break;
            }
            case 4: {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                nSampleSize = 24;
                break;
            }
            case 5: {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                nSampleSize = 32;
                break;
            }
            case 27: {
                encoding = AudioFormat.Encoding.ALAW;
                nSampleSize = 8;
            }
        }
        if (nSampleSize == 0) {
            throw new UnsupportedAudioFileException("unsupported AU file: unknown encoding " + nEncoding);
        }
        int nSampleRate = dataInputStream.readInt();
        if (nSampleRate <= 0) {
            throw new UnsupportedAudioFileException("corrupt AU file: sample rate must be positive");
        }
        int nNumChannels = dataInputStream.readInt();
        if (nNumChannels <= 0) {
            throw new UnsupportedAudioFileException("corrupt AU file: number of channels must be positive");
        }
        String desc = AuAudioFileReader.readDescription(dataInputStream, nDataOffset - 24);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (desc != "") {
            properties.put("title", desc);
        }
        AudioFormat format = new AudioFormat(encoding, nSampleRate, nSampleSize, nNumChannels, AuAudioFileReader.calculateFrameSize(nSampleSize, nNumChannels), nSampleRate, nSampleSize > 8);
        TAudioFileFormat audioFileFormat = new TAudioFileFormat(AudioFileFormat.Type.AU, format, nDataLength == -1 ? -1 : nDataLength / format.getFrameSize(), nDataLength == -1 ? -1 : nDataLength + nDataOffset, properties);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("AuAudioFileReader.getAudioFileFormat(InputStream, long): begin");
        }
        return audioFileFormat;
    }
}

