/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.audio;

public class AudioMath {
    public static final double MIN_GAIN = -100.0;
    public static final double MAX_GAIN = 20.0;
    public static final double MIN_TUNE = 16.0;
    public static final double STD_TUNE = 440.0;
    public static final double MAX_TUNE = 22050.0;

    public static int log2(int size) {
        assert ((size & size - 1) == 0) : "size must be a power of two";
        int log = 0;
        if (size >= 65536) {
            log += 16;
            size >>>= 16;
        }
        if (size >= 256) {
            log += 8;
            size >>>= 8;
        }
        if (size >= 16) {
            log += 4;
            size >>>= 4;
        }
        if (size >= 4) {
            log += 2;
            size >>>= 2;
        }
        if (size >= 2) {
            ++log;
        }
        return log;
    }

    public static double dbToLevel(double value) {
        return Math.pow(10.0, value / 20.0);
    }

    public static double levelToDb(double value) {
        return 20.0 * Math.log10(value);
    }

    public static double dbToLevel0(double value) {
        if (value <= -100.0) {
            return 0.0;
        }
        return AudioMath.dbToLevel(value);
    }

    public static double levelToDb0(double value) {
        double result = AudioMath.levelToDb(value);
        if (result < -100.0) {
            return -100.0;
        }
        return result;
    }

    public static double dbToPowerLevel(double value) {
        return Math.pow(10.0, value / 10.0);
    }

    public static double powerLevelToDb(double value) {
        return 10.0 * Math.log10(value);
    }

    public static double powerLevelToDb0(double value) {
        double result = AudioMath.powerLevelToDb(value);
        if (result < -100.0) {
            return -100.0;
        }
        return result;
    }

    public static float energy(float[] samples) {
        float total = 0.0f;
        float[] fArray = samples;
        int n = samples.length;
        int n2 = 0;
        while (n2 < n) {
            float value = fArray[n2];
            total += value * value;
            ++n2;
        }
        return (float)Math.sqrt(total / (float)samples.length);
    }

    public static double gcd(double a, double b) {
        double epsilon = 2.3283064365386963E-10;
        while (a > epsilon) {
            if (a < b) {
                double swap = a;
                a = b;
                b = swap;
            }
            a %= b;
        }
        return b;
    }

    public static double gcd(double ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("gcd() requires at least one value");
        }
        double result = values[0];
        int i = 1;
        while (i < values.length) {
            result = AudioMath.gcd(result, values[i]);
            ++i;
        }
        return result;
    }

    public static boolean isPowerOfTwo(int value) {
        if (value <= 0) {
            return false;
        }
        return (value & value - 1) == 0;
    }
}

