/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.audio;

import java.io.IOException;
import java.util.BitSet;
import org.corebounce.common.audio.IAudioSource;
import org.corebounce.common.audio.IMultiChannelAudioSource;
import org.corebounce.common.log.Debug;

public class DemuxAudioSource
implements IAudioSource,
IMultiChannelAudioSource {
    private final IAudioSource[] audioSources;
    private final IMultiChannelAudioSource mcAudioSource;
    private int chan;
    private float[][] buffer;
    private final BitSet channelsRead = new BitSet();
    private int mcAmount = -1;

    public DemuxAudioSource(IAudioSource[] audioSources) {
        this.audioSources = audioSources;
        this.mcAudioSource = null;
    }

    public DemuxAudioSource(IMultiChannelAudioSource mcAudioSource) {
        this.mcAudioSource = mcAudioSource;
        this.audioSources = null;
    }

    public int getChan() {
        return this.chan;
    }

    public void setChan(int chan) {
        this.chan = chan;
    }

    public int getNbChannels() {
        if (this.mcAudioSource != null) {
            return this.mcAudioSource.getNbChannels();
        }
        return this.audioSources.length;
    }

    public int getSamples(float[] target, int offset, int count) {
        if (this.audioSources != null) {
            return this.audioSources[this.chan].getSamples(target, offset, count);
        }
        if (this.buffer == null || this.buffer[0].length < count) {
            this.buffer = new float[this.getNbChannels()][count];
        }
        if (this.channelsRead.get(this.chan) || this.mcAmount < 0) {
            try {
                this.mcAmount = this.mcAudioSource.getSamples(this.buffer);
            }
            catch (IOException ex) {
                Debug.error(ex);
                this.mcAmount = 0;
            }
            this.channelsRead.clear();
        }
        this.channelsRead.set(this.chan);
        System.arraycopy(this.buffer[this.chan], 0, target, offset, this.mcAmount);
        return this.mcAmount;
    }

    public int getSamples(float[][] target) throws IOException {
        if (this.mcAudioSource != null) {
            return this.mcAudioSource.getSamples(target);
        }
        int result = 0;
        int i = 0;
        while (i < this.audioSources.length) {
            result = this.audioSources[i].getSamples(target[i], 0, target[i].length);
            ++i;
        }
        return result;
    }
}

