/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.audio.device;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import org.corebounce.common.audio.device.AudioException;
import org.corebounce.common.audio.device.IAudioDevice;

public class JavaSoundDevice
implements IAudioDevice {
    private static final String FALLBACK_COMPATIBLE_PLAYLINE_NAME = "Java Sound Audio Engine";
    private SourceDataLine playLine;
    private TargetDataLine recordLine;
    private int recordFrameSize;
    private int playFrameSize;
    private byte[] buffer;

    public void setup(int recordDeviceNum, int nbRecordChans, int playDeviceNum, int nbPlayChans, int rate, int nbFrames, int nbBuffers) throws AudioException {
        DataLine.Info info;
        AudioFormat format;
        if (this.playLine != null) {
            this.playLine.close();
            this.playLine = null;
        }
        if (this.recordLine != null) {
            this.recordLine.close();
            this.recordLine = null;
        }
        if (recordDeviceNum != 0) {
            throw new AudioException("Record device not supported: {0}", recordDeviceNum);
        }
        if (playDeviceNum != 0) {
            throw new AudioException("Playback device not supported: {0}", playDeviceNum);
        }
        this.recordFrameSize = nbFrames * nbRecordChans;
        this.playFrameSize = nbFrames * nbPlayChans;
        this.buffer = null;
        if (nbRecordChans == 0 && nbPlayChans == 0) {
            return;
        }
        if (nbFrames * nbBuffers < 1024) {
            throw new AudioException();
        }
        int nbChans = nbPlayChans > nbRecordChans ? nbPlayChans : nbRecordChans;
        int bufferSize = nbFrames * nbBuffers * nbChans * 2;
        if (bufferSize < 2048) {
            bufferSize = 2048;
        }
        if (nbPlayChans > 0) {
            format = new AudioFormat(rate, 16, nbPlayChans, true, false);
            info = new DataLine.Info(SourceDataLine.class, format);
            try {
                this.playLine = (SourceDataLine)AudioSystem.getLine(info);
                this.playLine.open(format);
                System.out.println("Playing using " + this.playLine.getClass());
            }
            catch (LineUnavailableException ex) {
                Mixer.Info fallback = this.getFallBackCompatibleMixer();
                if (fallback != null) {
                    try {
                        this.playLine = AudioSystem.getSourceDataLine(format, fallback);
                        this.playLine.open(format);
                        System.out.println("Playing using " + this.playLine.getClass());
                    }
                    catch (LineUnavailableException ex2) {
                        throw new AudioException(ex2);
                    }
                }
                throw new AudioException(ex);
            }
        }
        if (nbRecordChans > 0) {
            try {
                format = new AudioFormat(rate, 16, nbRecordChans, true, false);
                info = new DataLine.Info(TargetDataLine.class, format);
                this.recordLine = (TargetDataLine)AudioSystem.getLine(info);
                this.recordLine.open(format);
                System.out.println("Recording using " + this.recordLine.getClass());
            }
            catch (LineUnavailableException ex) {
                throw new AudioException(ex);
            }
        }
        this.buffer = this.playFrameSize > this.recordFrameSize ? new byte[this.playFrameSize * 2] : new byte[this.recordFrameSize * 2];
    }

    private Mixer.Info getFallBackCompatibleMixer() {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int n = infoArray.length;
        int n2 = 0;
        while (n2 < n) {
            Mixer.Info mixer = infoArray[n2];
            if (mixer.getName().toLowerCase().startsWith(FALLBACK_COMPATIBLE_PLAYLINE_NAME.toLowerCase())) {
                return mixer;
            }
            ++n2;
        }
        return null;
    }

    public boolean recordBuffer(float[] samples, int offset, int count) {
        assert (count == this.recordFrameSize);
        if (!this.recordLine.isRunning()) {
            this.recordLine.start();
        }
        this.recordLine.read(this.buffer, 0, this.recordFrameSize * 2);
        boolean xrun = this.recordLine.available() == this.recordLine.getBufferSize();
        int j = 0;
        int i = offset;
        while (i < offset + count) {
            int value = (this.buffer[j + 0] & 0xFF) + (this.buffer[j + 1] << 8);
            j += 2;
            samples[i] = (float)value / 32767.0f;
            ++i;
        }
        return !xrun;
    }

    public boolean playBuffer(float[] samples, int offset, int count) {
        assert (count == this.playFrameSize);
        if (!this.playLine.isRunning()) {
            this.playLine.start();
        }
        int j = 0;
        int i = offset;
        while (i < offset + count) {
            float sample = samples[i];
            int value = (double)sample < -1.0 ? Short.MIN_VALUE : ((double)sample >= 1.0 ? Short.MAX_VALUE : (int)(sample * 32767.0f));
            this.buffer[j++] = (byte)(value & 0xFF);
            this.buffer[j++] = (byte)(value >>> 8);
            ++i;
        }
        int amount = this.playFrameSize * 2;
        this.playLine.write(this.buffer, 0, amount);
        boolean xrun = this.playLine.available() == this.playLine.getBufferSize();
        return !xrun;
    }

    public boolean setPaused(boolean value) {
        if (this.playLine != null) {
            if (value && this.playLine.isRunning()) {
                this.playLine.stop();
            } else if (!value && !this.playLine.isRunning()) {
                this.playLine.start();
            }
        }
        if (this.recordLine != null) {
            if (value && this.recordLine.isRunning()) {
                this.recordLine.stop();
            } else if (!value && !this.recordLine.isRunning()) {
                this.recordLine.start();
            }
        }
        return true;
    }

    public int getPlayBufferSize() {
        if (this.playLine != null) {
            return (this.playLine.getBufferSize() - this.playLine.available()) / 2;
        }
        return -1;
    }

    public int getRecordBufferSize() {
        if (this.recordLine != null) {
            return this.recordLine.available() / 2;
        }
        return -1;
    }

    public void drain() {
        if (this.playLine != null && this.playLine.isRunning()) {
            this.playLine.drain();
        }
    }

    public boolean prefersRealTime() {
        return false;
    }

    public int preferredFrameSize() {
        return 4096;
    }

    public int preferredNumberOfBuffers() {
        return 2;
    }
}

