/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.audio.file;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AudioEncodingType {
    ENC_8BIT_S(1){

        public void decode(byte[] source, float[] target, int length) {
            int srcIndex = 0;
            int i = 0;
            while (i < length) {
                target[i] = (float)source[srcIndex++] / 128.0f;
                ++i;
            }
        }

        public void encode(float[] source, byte[] target, int length) {
            AudioEncodingType.mulAndCrop(source, 128.0f, -128.0f, 127.0f, length);
            int dstIndex = 0;
            int i = 0;
            while (i < length) {
                target[dstIndex++] = (byte)source[i];
                ++i;
            }
        }
    }
    ,
    ENC_8BIT_U(1){

        public void decode(byte[] source, float[] target, int length) {
            int srcIndex = 0;
            int i = 0;
            while (i < length) {
                target[i] = (float)((byte)(source[srcIndex++] + 128)) / 128.0f;
                ++i;
            }
        }

        public void encode(float[] source, byte[] target, int length) {
            AudioEncodingType.mulAndCrop(source, 128.0f, -128.0f, 127.0f, length);
            int dstIndex = 0;
            int i = 0;
            while (i < length) {
                target[dstIndex++] = (byte)((byte)source[i] + 128);
                ++i;
            }
        }
    }
    ,
    ENC_16BIT_LE(2){

        public void decode(byte[] source, float[] target, int length) {
            int srcIndex = 0;
            int i = 0;
            while (i < length) {
                target[i] = (float)(source[srcIndex++] & 0xFF | source[srcIndex++] << 8) / 32768.0f;
                ++i;
            }
        }

        public void encode(float[] source, byte[] target, int length) {
            AudioEncodingType.mulAndCrop(source, 32768.0f, -32768.0f, 32767.0f, length);
            int dstIndex = 0;
            int i = 0;
            while (i < length) {
                target[dstIndex++] = (byte)((int)source[i] & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] >> 8 & 0xFF);
                ++i;
            }
        }
    }
    ,
    ENC_16BIT_BE(2){

        public void decode(byte[] source, float[] target, int length) {
            int srcIndex = 0;
            int i = 0;
            while (i < length) {
                target[i] = (float)(source[srcIndex++] << 8 | source[srcIndex++] & 0xFF) / 32768.0f;
                ++i;
            }
        }

        public void encode(float[] source, byte[] target, int length) {
            AudioEncodingType.mulAndCrop(source, 32768.0f, -32768.0f, 32767.0f, length);
            int dstIndex = 0;
            int i = 0;
            while (i < length) {
                target[dstIndex++] = (byte)((int)source[i] >> 8 & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] & 0xFF);
                ++i;
            }
        }
    }
    ,
    ENC_24BIT_LE(3){

        public void decode(byte[] source, float[] target, int length) {
            int srcIndex = 0;
            int i = 0;
            while (i < length) {
                target[i] = (float)(source[srcIndex++] & 0xFF | (source[srcIndex++] & 0xFF) << 8 | source[srcIndex++] << 16) / 8388608.0f;
                ++i;
            }
        }

        public void encode(float[] source, byte[] target, int length) {
            AudioEncodingType.mulAndCrop(source, 8388608.0f, -8388608.0f, 8388607.0f, length);
            int dstIndex = 0;
            int i = 0;
            while (i < length) {
                target[dstIndex++] = (byte)((int)source[i] & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] >> 8 & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] >> 16 & 0xFF);
                ++i;
            }
        }
    }
    ,
    ENC_24BIT_BE(3){

        public void decode(byte[] source, float[] target, int length) {
            int srcIndex = 0;
            int i = 0;
            while (i < length) {
                target[i] = (float)(source[srcIndex++] << 16 | (source[srcIndex++] & 0xFF) << 8 | source[srcIndex++] & 0xFF) / 8388608.0f;
                ++i;
            }
        }

        public void encode(float[] source, byte[] target, int length) {
            AudioEncodingType.mulAndCrop(source, 8388608.0f, -8388608.0f, 8388607.0f, length);
            int dstIndex = 0;
            int i = 0;
            while (i < length) {
                target[dstIndex++] = (byte)((int)source[i] >> 16 & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] >> 8 & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] & 0xFF);
                ++i;
            }
        }
    }
    ,
    ENC_32BIT_LE(4){

        public void decode(byte[] source, float[] target, int length) {
            int srcIndex = 0;
            int i = 0;
            while (i < length) {
                target[i] = (float)(source[srcIndex++] & 0xFF | (source[srcIndex++] & 0xFF) << 8 | (source[srcIndex++] & 0xFF) << 16 | source[srcIndex++] << 24) / 2.1474836E9f;
                ++i;
            }
        }

        public void encode(float[] source, byte[] target, int length) {
            AudioEncodingType.mulAndCrop(source, 2.1474836E9f, -2.1474836E9f, 2.1474836E9f, length);
            int dstIndex = 0;
            int i = 0;
            while (i < length) {
                target[dstIndex++] = (byte)((int)source[i] & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] >> 8 & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] >> 16 & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] >> 24 & 0xFF);
                ++i;
            }
        }
    }
    ,
    ENC_32BIT_BE(4){

        public void decode(byte[] source, float[] target, int length) {
            int srcIndex = 0;
            int i = 0;
            while (i < length) {
                target[i] = (float)(source[srcIndex++] << 24 | (source[srcIndex++] & 0xFF) << 16 | (source[srcIndex++] & 0xFF) << 8 | source[srcIndex++] & 0xFF) / 2.1474836E9f;
                ++i;
            }
        }

        public void encode(float[] source, byte[] target, int length) {
            AudioEncodingType.mulAndCrop(source, 2.1474836E9f, -2.1474836E9f, 2.1474836E9f, length);
            int dstIndex = 0;
            int i = 0;
            while (i < length) {
                target[dstIndex++] = (byte)((int)source[i] >> 24 & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] >> 16 & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] >> 8 & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] & 0xFF);
                ++i;
            }
        }
    };

    private final int bytesPerSample;

    private AudioEncodingType(int bytesPerSample) {
        this.bytesPerSample = bytesPerSample;
    }

    public int getBytesPerSample() {
        return this.bytesPerSample;
    }

    public abstract void decode(byte[] var1, float[] var2, int var3);

    public abstract void encode(float[] var1, byte[] var2, int var3);

    private static void mulAndCrop(float[] source, float mult, float min, float max, int length) {
        int i = 0;
        while (i < length) {
            float s = source[i] * mult;
            source[i] = s < min ? min : (s > max ? max : s);
            ++i;
        }
    }

    /* synthetic */ AudioEncodingType(String string, int n, int n2, AudioEncodingType audioEncodingType) {
        this(n2);
    }
}

