/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp;

import java.util.Map;
import org.corebounce.common.dsp.BooFFT;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.struct.CacheMap;
import org.corebounce.common.thread.Task;
import org.corebounce.common.thread.ThreadPool;

public class PooFFT
extends BooFFT {
    private static final int PARALLEL_THRESHOLD_LOG = 12;
    private static final ThreadLocal<Map<Integer, PooFFT>> instanceCache = new ThreadLocal<Map<Integer, PooFFT>>(){

        @Override
        protected Map<Integer, PooFFT> initialValue() {
            return new CacheMap<Integer, PooFFT>();
        }
    };

    public static synchronized PooFFT getInstance(int length) {
        Map<Integer, PooFFT> ffts = instanceCache.get();
        PooFFT result = ffts.get(length);
        if (result == null) {
            result = new PooFFT(length);
            ffts.put(length, result);
        }
        return result;
    }

    protected PooFFT(int length) {
        super(length);
    }

    private final void passP(final Cmplx[] a, final int ab, final Cmplx[] w, final int n) {
        Task part1 = new Task(){

            public void run() {
                int a0 = ab;
                int a1 = 2 * n + ab;
                int a2 = 4 * n + ab;
                int a3 = 6 * n + ab;
                PooFFT.this.butterflyFirst(a[a0], a[a1], a[a2], a[a3]);
                int wb = 1;
                do {
                    PooFFT.this.butterfly(a[++a0], a[++a1], a[++a2], a[++a3], w[wb].re, w[wb].im);
                } while (++wb < n);
            }
        };
        Task part2 = new Task(){

            public void run() {
                int a0 = 1 * n + ab;
                int a1 = 3 * n + ab;
                int a2 = 5 * n + ab;
                int a3 = 7 * n + ab;
                int wb = n;
                PooFFT.this.butterflyHalf(a[a0], a[a1], a[a2], a[a3]);
                --wb;
                do {
                    PooFFT.this.butterfly(a[++a0], a[++a1], a[++a2], a[++a3], w[wb].im, w[wb].re);
                } while (--wb > 0);
            }
        };
        ThreadPool.executeAndWait(part1, part2);
    }

    protected void fftBig(final Cmplx[] a, final int off, final int log) {
        int size = 1 << log;
        final int size4 = size / 4;
        if (log >= 12) {
            Task part1 = new Task(){

                public void run() {
                    PooFFT.this.fftN(a, off, log - 1);
                }
            };
            Task part2 = new Task(){

                public void run() {
                    PooFFT.this.fftN(a, off + size4 + size4, log - 2);
                }
            };
            Task part3 = new Task(){

                public void run() {
                    PooFFT.this.fftN(a, off + size4 + size4 + size4, log - 2);
                }
            };
            ThreadPool.executeAndWait(part1, part2, part3);
            this.passP(a, off, this.roots[log], size / 8);
        } else {
            this.fftN(a, off, log - 1);
            this.fftN(a, off + size4 + size4, log - 2);
            this.fftN(a, off + size4 + size4 + size4, log - 2);
            this.pass2(a, off, this.roots[log], size / 8);
        }
    }

    public static synchronized /* bridge */ /* synthetic */ BooFFT getInstance(int n) {
        return PooFFT.getInstance(n);
    }
}

