/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.resample;

import java.text.DecimalFormat;

public class LinearInterpolatedBuffer {
    private final float[] buffer;

    public LinearInterpolatedBuffer(int size) {
        this.buffer = new float[size];
    }

    public int getSize() {
        return this.buffer.length;
    }

    public void set(int index, float value) {
        this.buffer[index] = value;
    }

    public float get(int index) {
        return this.buffer[index];
    }

    public float get(float index) {
        assert (index >= 0.0f);
        int floor = (int)index;
        float w2 = index - (float)floor;
        float v1 = this.buffer[floor];
        float v2 = this.buffer[floor + 1];
        return v1 + (v2 - v1) * w2;
    }

    public static void main(String[] args) {
        LinearInterpolatedBuffer buffer = new LinearInterpolatedBuffer(11);
        int i = 0;
        while (i < 11) {
            buffer.set(i, i);
            ++i;
        }
        DecimalFormat format = new DecimalFormat("#0.000");
        float f = 0.0f;
        while (f < 10.0f) {
            System.out.print(String.valueOf(format.format(buffer.get(f))) + " ");
            f += 0.1f;
        }
        System.out.println();
        f = 0.0f;
        while (f < 10.0f) {
            System.out.print(String.valueOf(format.format(buffer.get(f))) + " ");
            f += 0.11111111f;
        }
        System.out.println();
    }
}

