/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.resample;

import org.corebounce.common.audio.IAudioSource;
import org.corebounce.common.dsp.resample.BufferedResampler;
import org.corebounce.common.dsp.resample.ISweepableResampler;

public class SampleAndHoldResampler
extends BufferedResampler
implements ISweepableResampler {
    private double step;
    private double index;

    public SampleAndHoldResampler(IAudioSource source, double ratio, int bufferSize) {
        super(source, bufferSize, 0);
        this.step = 1.0 / ratio;
        this.reset();
    }

    public void setRatio(double ratio) {
        this.step = 1.0 / ratio;
    }

    public void reset() {
        super.reset();
        this.index = (double)this.bufferSize - this.step;
    }

    public int resample(float[] output) {
        int sourceIndex = 0;
        int i = 0;
        while (i < output.length) {
            this.index += this.step;
            sourceIndex = (int)this.index;
            sourceIndex -= super.prefetch(sourceIndex);
            output[i] = super.getSample(sourceIndex);
            ++i;
        }
        if (sourceIndex <= this.eosIndex) {
            return output.length;
        }
        sourceIndex = (int)(this.index + this.step);
        return (int)((double)output.length - (double)(sourceIndex - this.eosIndex) / this.step + 0.5);
    }

    protected void fetchNextBuffer() {
        super.fetchNextBuffer();
        this.index -= (double)this.bufferSize;
    }

    public int getLatency() {
        return 0;
    }
}

