/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.resample;

import java.util.Arrays;
import org.corebounce.common.audio.IAudioSource;
import org.corebounce.common.dsp.resample.IResetable;
import org.corebounce.common.dsp.resample.SincLiBuffer;
import org.corebounce.common.math.Fraction;

public class SincLiConvolvedAudioSource
implements IAudioSource,
IResetable {
    private final IAudioSource source;
    private final SincLiBuffer sincBuffer;
    private final int nbZeroCross;
    private final int denom;
    private final int step;
    private final float amplitudeCorrection;
    private final int bufferSize;
    private final int historySize;
    private final float[] buffer;
    private int eosIndex;
    private int index;
    private final float sincShiftScale;
    private final int halfDenom;
    private static final float fPI = (float)Math.PI;
    private static final float fPIhalf4check = 1.5717964f;

    public SincLiConvolvedAudioSource(IAudioSource source, int nbSamplesPerZeroCross, int nbZeroCross, float kaiserAttenuationDb, float stretch, int bufferSize, Fraction srcStep, float amplitudeCorrection) {
        this.source = source;
        this.sincBuffer = new SincLiBuffer(nbSamplesPerZeroCross, nbZeroCross, kaiserAttenuationDb, stretch);
        this.nbZeroCross = nbZeroCross;
        this.bufferSize = bufferSize;
        this.historySize = nbZeroCross * 2 + 1;
        this.buffer = new float[bufferSize + this.historySize];
        this.amplitudeCorrection = amplitudeCorrection;
        this.denom = (int)srcStep.getDenom();
        this.step = (int)srcStep.getExtNum();
        this.index = (bufferSize + this.historySize - nbZeroCross) * this.denom - this.step;
        this.eosIndex = this.buffer.length - nbZeroCross;
        this.sincShiftScale = (float)Math.PI / (float)this.denom;
        this.halfDenom = (this.denom - 1) / 2;
    }

    public void reset() {
        Arrays.fill(this.buffer, 0.0f);
        this.index = (this.bufferSize + this.historySize - this.nbZeroCross) * this.denom - this.step;
        this.eosIndex = this.buffer.length - this.nbZeroCross;
        if (this.source instanceof IResetable) {
            ((IResetable)((Object)this.source)).reset();
        }
    }

    public int getSamples(float[] target, int start, int count) {
        int sourceIndex = 0;
        int i = 0;
        while (i < count) {
            this.index += this.step;
            sourceIndex = (this.index + this.halfDenom) / this.denom;
            float sincShift = (float)(this.index - sourceIndex * this.denom) * this.sincShiftScale;
            assert (sincShift >= -1.5717964f && sincShift <= 1.5717964f);
            float result = 0.0f;
            float sincOffset = (float)(-this.nbZeroCross) * (float)Math.PI + sincShift;
            sourceIndex -= this.prefetch(sourceIndex + this.nbZeroCross);
            int offset = -this.nbZeroCross;
            while (offset <= this.nbZeroCross) {
                float sample = this.buffer[sourceIndex - offset];
                float sinc = this.sincBuffer.get(sincOffset);
                result += sample * sinc;
                sincOffset += (float)Math.PI;
                ++offset;
            }
            target[start + i] = result * this.amplitudeCorrection;
            ++i;
        }
        if (sourceIndex <= this.eosIndex) {
            return target.length;
        }
        sourceIndex = (this.index + this.step + this.halfDenom) / this.denom;
        return Math.max(target.length - ((sourceIndex - this.eosIndex) * this.denom + this.step / 2) / this.step, 0);
    }

    private int prefetch(int maxIndex) {
        int result = 0;
        while (maxIndex >= this.buffer.length) {
            this.fetchNextBuffer();
            maxIndex -= this.bufferSize;
            result += this.bufferSize;
        }
        return result;
    }

    private void fetchNextBuffer() {
        System.arraycopy(this.buffer, this.buffer.length - this.historySize, this.buffer, 0, this.historySize);
        this.eosIndex += this.source.getSamples(this.buffer, this.historySize, this.bufferSize);
        this.index -= this.bufferSize * this.denom;
        this.eosIndex -= this.bufferSize;
    }
}

