/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.resample;

import java.util.Arrays;
import org.corebounce.common.audio.IAudioSource;
import org.corebounce.common.dsp.resample.IResetable;
import org.corebounce.common.dsp.resample.KaiserLiBuffer;
import org.corebounce.common.dsp.resample.PolyphaseResampler;
import org.corebounce.common.dsp.resample.SincLiBuffer;

public class SweepableSincLiConvolvedAudioSource
implements IAudioSource,
IResetable {
    private final IAudioSource source;
    private final SincLiBuffer sincBuffer;
    private final KaiserLiBuffer kaiserBuffer;
    private final int nbZeroCross;
    private final float antiAliasing;
    private float stretch;
    private double step;
    private float amplitudeCorrection;
    private final int bufferSize;
    private final int historySize;
    private final float[] buffer;
    private int eosIndex;
    private double index;
    private static final float fPI = (float)Math.PI;
    private static final float fPIhalf4check = 1.5717964f;

    public SweepableSincLiConvolvedAudioSource(IAudioSource source, int nbSamplesPerZeroCross, int nbZeroCross, float kaiserAttenuationDb, int bufferSize, float antiAliasing, double ratio) {
        this.source = source;
        this.sincBuffer = new SincLiBuffer(nbSamplesPerZeroCross, nbZeroCross);
        this.kaiserBuffer = new KaiserLiBuffer(nbSamplesPerZeroCross, nbZeroCross, kaiserAttenuationDb);
        this.nbZeroCross = nbZeroCross;
        this.antiAliasing = antiAliasing;
        this.bufferSize = bufferSize;
        this.historySize = nbZeroCross * 2 + 1;
        this.buffer = new float[bufferSize + this.historySize];
        this.index = (double)(bufferSize + this.historySize - nbZeroCross) - 1.0 / ratio;
        this.eosIndex = this.buffer.length - nbZeroCross;
        this.setRatio(ratio);
    }

    public void setRatio(double ratio) {
        this.step = 1.0 / ratio;
        this.amplitudeCorrection = (float)Math.min(ratio, 1.0);
        if (ratio != 1.0 && (double)this.antiAliasing != 0.0) {
            this.amplitudeCorrection = (float)((double)this.amplitudeCorrection * (1.0 - (double)this.antiAliasing + (double)(this.antiAliasing * PolyphaseResampler.getBandWidth(this.nbZeroCross))));
        }
        this.stretch = 1.0f / this.amplitudeCorrection;
        assert (this.stretch >= 1.0f);
    }

    public void reset() {
        Arrays.fill(this.buffer, 0.0f);
        this.index = (double)(this.bufferSize + this.historySize - this.nbZeroCross) - this.step;
        this.eosIndex = this.buffer.length - this.nbZeroCross;
        if (this.source instanceof IResetable) {
            ((IResetable)((Object)this.source)).reset();
        }
    }

    public int getSamples(float[] target, int start, int count) {
        int sourceIndex = 0;
        int i = 0;
        while (i < count) {
            this.index += this.step;
            sourceIndex = (int)(this.index + 0.5);
            float sincShift = (float)(this.index - (double)sourceIndex) * (float)Math.PI;
            assert (sincShift >= -1.5717964f && sincShift <= 1.5717964f);
            float result = 0.0f;
            float sincOffset = (float)(-this.nbZeroCross) * (float)Math.PI + sincShift;
            sourceIndex -= this.prefetch(sourceIndex + this.nbZeroCross);
            int offset = -this.nbZeroCross;
            while (offset <= this.nbZeroCross) {
                float sample = this.buffer[sourceIndex - offset];
                float sinc = this.sincBuffer.get(sincOffset / this.stretch);
                float kaiser = this.kaiserBuffer.get(sincOffset);
                result += sample * sinc * kaiser;
                sincOffset += (float)Math.PI;
                ++offset;
            }
            target[start + i] = result * this.amplitudeCorrection;
            ++i;
        }
        if (sourceIndex <= this.eosIndex) {
            return target.length;
        }
        sourceIndex = (int)(this.index + this.step + 0.5);
        return Math.max((int)((double)target.length - (double)(sourceIndex - this.eosIndex) / this.step + 0.5), 0);
    }

    private int prefetch(int maxIndex) {
        int result = 0;
        while (maxIndex >= this.buffer.length) {
            this.fetchNextBuffer();
            maxIndex -= this.bufferSize;
            result += this.bufferSize;
        }
        return result;
    }

    private void fetchNextBuffer() {
        System.arraycopy(this.buffer, this.buffer.length - this.historySize, this.buffer, 0, this.historySize);
        this.eosIndex += this.source.getSamples(this.buffer, this.historySize, this.bufferSize);
        this.index -= (double)this.bufferSize;
        this.eosIndex -= this.bufferSize;
    }
}

