/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.TextComponent;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.JTextComponent;
import org.corebounce.common.gui.TableLayout;
import org.corebounce.common.log.Debug;
import org.corebounce.common.utils.Platform;

public class AwtTools {
    private static Dimension buttonDimension = null;
    private static String lafName = null;
    private static Map<Component, Boolean> detachedComponents = new WeakHashMap<Component, Boolean>();

    private AwtTools() {
    }

    public static void init() {
        if (Platform.isMacOsX()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
    }

    public static void setupHighQuality(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    public static void setupHighSpeed(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
    }

    public static void centerWindowOnScreen(Window window) {
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Point center = gEnv.getCenterPoint();
        Dimension wDim = window.getSize();
        int x = center.x - wDim.width / 2;
        int y = center.y - wDim.height / 2;
        window.setLocation(x, y);
    }

    public static void centerWindowOn(Window window, Component parent) {
        window.setLocationRelativeTo(parent);
    }

    public static Point getLocationInWindow(Component cmp) {
        Point location = cmp.getLocation();
        return AwtTools.getLocationInWindow(cmp, location);
    }

    public static Point getLocationInWindow(Component cmp, Point location) {
        Container parent = cmp.getParent();
        while (!(parent instanceof Window)) {
            Point parLocation = parent.getLocation();
            location.setLocation(location.x + parLocation.x, location.y + parLocation.y);
            parent = parent.getParent();
        }
        return location;
    }

    public static Point getLocationIn(Component cmp, Component parent) {
        Point location = cmp.getLocation();
        return AwtTools.getLocationIn(cmp, location, parent);
    }

    public static Point getLocationIn(Component cmp, Point location, Component parent) {
        Container parent0 = cmp.getParent();
        while (parent0 != parent) {
            Point parLocation = parent0.getLocation();
            location.setLocation(location.x + parLocation.x, location.y + parLocation.y);
            parent0 = parent0.getParent();
        }
        return location;
    }

    public static int getScreenX(MouseEvent e) {
        return e.getComponent().getLocationOnScreen().x + e.getX();
    }

    public static int getScreenY(MouseEvent e) {
        return e.getComponent().getLocationOnScreen().y + e.getY();
    }

    public static Window getWindow(Component cmp) {
        Container parent = cmp.getParent();
        while (parent != null && !(parent instanceof Window)) {
            parent = parent.getParent();
        }
        return (Window)parent;
    }

    public static Frame getFrame(Component cmp) {
        Container parent = cmp.getParent();
        while (parent != null && !(parent instanceof Frame)) {
            parent = parent.getParent();
        }
        return (Frame)parent;
    }

    public static void switchToNativeLookAndFeel() {
        try {
            String name = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(name);
        }
        catch (Throwable ex) {
            Debug.warn(ex);
        }
    }

    public static void switchToMetalLookAndFeel() {
        try {
            String name = UIManager.getCrossPlatformLookAndFeelClassName();
            UIManager.setLookAndFeel(name);
        }
        catch (Exception ex) {
            Debug.warn(ex);
        }
    }

    public static boolean switchToNimbusLookAndFeel() {
        boolean found = false;
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    found = true;
                    break;
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            Debug.warn(ex);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDetachedComponent(Component cmp) {
        Map<Component, Boolean> map = detachedComponents;
        synchronized (map) {
            detachedComponents.put(cmp, Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void swithToLookAndFeel(String lafClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(lafClassName);
        Frame[] frameArray = Frame.getFrames();
        int n = frameArray.length;
        int n2 = 0;
        while (n2 < n) {
            Frame frame = frameArray[n2];
            SwingUtilities.updateComponentTreeUI(frame);
            frame.validate();
            Window[] windowArray = frame.getOwnedWindows();
            int n3 = windowArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Window window = windowArray[n4];
                SwingUtilities.updateComponentTreeUI(window);
                window.validate();
                ++n4;
            }
            ++n2;
        }
        Map<Component, Boolean> map = detachedComponents;
        synchronized (map) {
            boolean success = false;
            while (!success) {
                try {
                    for (Component cmp : detachedComponents.keySet()) {
                        SwingUtilities.updateComponentTreeUI(cmp);
                        cmp.validate();
                    }
                    success = true;
                }
                catch (ConcurrentModificationException ex) {
                    success = false;
                }
            }
        }
    }

    public static void invokeAndWait(Runnable runnable) {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception ex) {
            Debug.warn(ex);
        }
    }

    public static void invokeInSwing(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static Dimension getDimension(Graphics2D g, String text) {
        TextLayout tl = new TextLayout(text, g.getFont(), g.getFontRenderContext());
        Rectangle2D rect = tl.getBounds();
        return new Dimension((int)(rect.getWidth() + 0.5), (int)(rect.getHeight() + 0.5));
    }

    public static synchronized Dimension getButtonDimension() {
        if (lafName == null || !lafName.equals(UIManager.getLookAndFeel().getName())) {
            buttonDimension = null;
            lafName = UIManager.getLookAndFeel().getName();
        }
        if (buttonDimension == null) {
            String TXT = "X";
            JFrame dummyFrame = new JFrame();
            dummyFrame.getContentPane().setLayout(new BorderLayout());
            JPanel panel = new JPanel();
            dummyFrame.getContentPane().add(panel);
            panel.setLayout(new TableLayout(2));
            int i = 0;
            while (i < 4) {
                JButton button = new JButton("X");
                panel.add(button);
                ++i;
            }
            dummyFrame.pack();
            Dimension buttonsDimension = panel.getSize();
            Dimension txtDimension = AwtTools.getDimension((Graphics2D)dummyFrame.getGraphics(), "X");
            dummyFrame.dispose();
            buttonDimension = new Dimension(buttonsDimension.width / 2 - txtDimension.width, buttonsDimension.height / 2 - txtDimension.height);
        }
        return buttonDimension;
    }

    public static Dimension getButtonDimension(Graphics2D g, String buttonText) {
        Dimension buttonDimension = AwtTools.getButtonDimension();
        Dimension textDimension = AwtTools.getDimension(g, buttonText);
        return new Dimension(buttonDimension.width + textDimension.width, buttonDimension.height + textDimension.height);
    }

    public static Dimension getTypicalDimension(Graphics2D g, int nbTextCols, int nbTextLines, int nbButtonsHorz, int nbButtonsVert) {
        String referenceText = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        Dimension refDimension = AwtTools.getDimension(g, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
        Dimension result = new Dimension(refDimension.width * nbTextCols / "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".length(), refDimension.height * nbTextLines);
        if (nbButtonsHorz > 0 || nbButtonsVert > 0) {
            Dimension buttonDimension = AwtTools.getButtonDimension();
            result = new Dimension(result.width + buttonDimension.width * nbButtonsHorz, result.height + buttonDimension.height * nbButtonsVert);
        }
        return result;
    }

    public static boolean isContiguousMultiSelect(InputEvent e) {
        int keyMask = 64;
        return (e.getModifiersEx() & keyMask) != 0;
    }

    public static boolean isDiscontiguousMultiSelect(InputEvent e) {
        int keyMask = Platform.isMacOsX() ? 256 : 128;
        return (e.getModifiersEx() & keyMask) != 0;
    }

    public static boolean isMultiSelect(InputEvent e) {
        return AwtTools.isContiguousMultiSelect(e) || AwtTools.isDiscontiguousMultiSelect(e);
    }

    private static Action wrapShortcutKeyAction(final Action target) {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Component cmp;
                Window window;
                Component focused;
                Object source = e.getSource();
                if (source instanceof Component && ((focused = (window = AwtTools.getWindow(cmp = (Component)source)).getFocusOwner()) instanceof JTextComponent || focused instanceof TextComponent)) {
                    return;
                }
                target.actionPerformed(e);
            }
        };
    }

    public static void addKeyboardShortcut(AbstractButton button, KeyStroke keyStroke) {
        if (button.getAction() == null) {
            throw new IllegalArgumentException("The button must have an action");
        }
        Object actionKey = new Object();
        button.getInputMap(2).put(keyStroke, actionKey);
        button.getActionMap().put(actionKey, AwtTools.wrapShortcutKeyAction(button.getAction()));
    }

    public static void addKeyboardShortcut(AbstractButton button, int keyCode) {
        AwtTools.addKeyboardShortcut(button, KeyStroke.getKeyStroke(keyCode, 0));
    }

    public static void addKeyboardShortcut(JComponent button, KeyStroke keyStroke, Action action) {
        Object actionKey = new Object();
        button.getInputMap(2).put(keyStroke, actionKey);
        button.getActionMap().put(actionKey, AwtTools.wrapShortcutKeyAction(action));
    }

    public static void addKeyboardShortcut(JComponent button, int when, KeyStroke keyStroke, Action action) {
        Object actionKey = new Object();
        button.getInputMap(when).put(keyStroke, actionKey);
        button.getActionMap().put(actionKey, action);
    }

    public static int showYesNoCancelDialog(JFrame parent, String message, String title, String yesAction, String noAction) {
        if (Platform.isMacOsX() || Platform.isUnixLikePlatform()) {
            JButton noOption = new JButton(noAction);
            JPanel gap = new JPanel();
            gap.setPreferredSize(new Dimension(48, 8));
            JButton yesOption = new JButton(yesAction);
            JButton cancelOption = new JButton("Cancel");
            Object[] options = new Object[]{yesOption, cancelOption, gap, noOption};
            JOptionPane pane = new JOptionPane(message, 2, 1, null, options, yesOption);
            pane.setMessage(message);
            final JDialog dialog = pane.createDialog(parent, title);
            final AtomicInteger result = new AtomicInteger(2);
            noOption.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    result.set(1);
                    dialog.dispose();
                }
            });
            cancelOption.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    result.set(2);
                    dialog.dispose();
                }
            });
            yesOption.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    result.set(0);
                    dialog.dispose();
                }
            });
            dialog.setVisible(true);
            return result.get();
        }
        return JOptionPane.showConfirmDialog(parent, message, title, 1, 2);
    }
}

