/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.gui;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.lang.ref.SoftReference;
import org.corebounce.common.log.Debug;

public class CachedImage {
    private final int transparency;
    private SoftReference<Image> imageRef;

    public CachedImage(int transparency) {
        this.transparency = transparency;
    }

    private void renderOffScreen(OffScreenPainter offScreenPainter, Image image) {
        Graphics2D g = (Graphics2D)image.getGraphics();
        offScreenPainter.paintOffScreen(g);
        g.dispose();
    }

    public void paintUsing(Graphics2D g, int width, int height, OffScreenPainter offScreenPainter, OnScreenPainter onScreenPainter) {
        int returnCode;
        Image image;
        GraphicsConfiguration gc = g.getDeviceConfiguration();
        Image image2 = image = this.imageRef == null ? null : this.imageRef.get();
        if (image instanceof BufferedImage) {
            BufferedImage bImage = (BufferedImage)image;
            if (bImage.getWidth() != width || bImage.getHeight() != height) {
                bImage = gc.createCompatibleImage(width, height, this.transparency);
                this.imageRef = new SoftReference<BufferedImage>(bImage);
            }
            this.renderOffScreen(offScreenPainter, bImage);
            onScreenPainter.paintOnScreen(g, bImage);
            return;
        }
        VolatileImage vImage = (VolatileImage)image;
        if (vImage == null || vImage.getWidth() != width || vImage.getHeight() != height) {
            vImage = gc.createCompatibleVolatileImage(width, height, this.transparency);
            this.imageRef = new SoftReference<VolatileImage>(vImage);
            this.renderOffScreen(offScreenPainter, vImage);
        }
        if ((returnCode = vImage.validate(gc)) == 1) {
            this.renderOffScreen(offScreenPainter, vImage);
        } else if (returnCode == 2) {
            vImage = gc.createCompatibleVolatileImage(width, height, this.transparency);
            this.imageRef = new SoftReference<VolatileImage>(vImage);
            this.renderOffScreen(offScreenPainter, vImage);
        }
        onScreenPainter.paintOnScreen(g, vImage);
        if (vImage.contentsLost()) {
            Debug.info("VolatileImage lost, using BufferedImage", new Object[0]);
            vImage.flush();
            BufferedImage bImage = gc.createCompatibleImage(width, height, this.transparency);
            this.imageRef = new SoftReference<BufferedImage>(bImage);
            this.renderOffScreen(offScreenPainter, bImage);
            onScreenPainter.paintOnScreen(g, bImage);
        }
    }

    public static interface OffScreenPainter {
        public void paintOffScreen(Graphics2D var1);
    }

    public static interface OnScreenPainter {
        public void paintOnScreen(Graphics2D var1, Image var2);
    }
}

