/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.gui;

import java.awt.Image;
import java.net.URL;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.corebounce.common.struct.CacheMap;
import org.corebounce.common.utils.MultiKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconLoader {
    private static Map<MultiKey, ImageIcon> iconCache = new CacheMap<MultiKey, ImageIcon>();

    public static synchronized ImageIcon getImageIcon(Class<?> forClass, String path, int width, int height) {
        MultiKey key = new MultiKey(forClass, path, width, height);
        ImageIcon icon = iconCache.get(key);
        if (icon == null) {
            URL imgURL = forClass.getResource(path);
            if (imgURL == null) {
                return null;
            }
            icon = new ImageIcon(imgURL);
            if (width > 0 && icon.getIconWidth() != width || height > 0 && icon.getIconHeight() != height) {
                if (width <= 0) {
                    width = icon.getIconWidth();
                }
                if (height <= 0) {
                    height = icon.getIconHeight();
                }
                Image img = icon.getImage().getScaledInstance(width, height, 4);
                icon = new ImageIcon(img);
            }
            iconCache.put(key, icon);
        }
        return icon;
    }

    public static Icon getIcon(Class<?> forClass, String path, int size) {
        return IconLoader.getImageIcon(forClass, path, size, size);
    }

    public static Image getImage(Class<?> forClass, String path, int size) {
        ImageIcon icon = (ImageIcon)IconLoader.getIcon(forClass, path, size);
        return icon.getImage();
    }
}

