/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public class CodecInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 1024;
    private final Charset dstCharset;
    private final Reader reader;
    private byte[] buffer;
    private int available;
    private int index;

    public CodecInputStream(InputStream source, Charset srcCharset, Charset dstCharset) {
        this.dstCharset = dstCharset;
        this.reader = new InputStreamReader(source, srcCharset);
    }

    public int read() throws IOException {
        char[] chars;
        int amount;
        if (this.index >= this.available && (amount = this.reader.read(chars = new char[1024])) > 0) {
            ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, this.dstCharset);
            ((Writer)writer).write(chars, 0, amount);
            ((Writer)writer).flush();
            this.available = output.size();
            this.buffer = output.toByteArray();
            this.index = 0;
        }
        if (this.index >= this.available) {
            return -1;
        }
        return this.buffer[this.index++];
    }
}

