/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.io;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.corebounce.common.io.Prefs;
import org.corebounce.common.io.TempFileRepository;
import org.corebounce.common.log.Debug;
import org.corebounce.common.utils.AppUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TempFileManager {
    private static final TempFileRepository repository;
    private static File tempDirectory;
    private static File sessionDirectory;

    static {
        tempDirectory = null;
        sessionDirectory = null;
        TempFileRepository r = Prefs.getObject(TempFileManager.class, "tempFiles", null, TempFileRepository.class);
        if (r == null) {
            r = new TempFileRepository();
        }
        repository = r;
        TempFileManager.purgeTempFiles();
        TempFileManager.createTempDirs();
    }

    private TempFileManager() {
    }

    private static void purgeTempFiles() {
        Iterator<File> iter = TempFileManager.getTempFiles().iterator();
        while (iter.hasNext()) {
            File file = iter.next();
            if (!file.exists()) {
                iter.remove();
                continue;
            }
            if (file.isDirectory()) {
                boolean success = TempFileManager.deleteDir(file);
                if (success) {
                    iter.remove();
                    Debug.info("Deleted temporary directory {0}", file.getPath());
                    continue;
                }
                Debug.info("Failed to delete temporary directory {0}", file.getPath());
                continue;
            }
            if (file.delete()) {
                iter.remove();
                Debug.info("Deleted temporary file {0}", file.getPath());
                continue;
            }
            Debug.info("Failed to delete temporary file {0}", file.getPath());
        }
    }

    private static boolean deleteDir(File dir) {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File item = fileArray[n2];
            if (item.isDirectory()) {
                TempFileManager.deleteDir(item);
            } else {
                item.delete();
                Debug.info("Deleted temporary file {0}", item.getPath());
            }
            ++n2;
        }
        return dir.delete();
    }

    private static void sync() {
        Prefs.putObject(TempFileManager.class, "tempFiles", repository);
    }

    private static void createTempDirs() {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String appName = AppUtils.getAppName().replace(' ', '-');
        if (!appName.equals("")) {
            appName = String.valueOf(appName) + "-";
        }
        if ((tempDirectory = new File(baseDir, String.valueOf(appName) + "temp")).isDirectory() || tempDirectory.mkdirs()) {
            TempFileManager.addTempFile(tempDirectory);
            tempDirectory.deleteOnExit();
        } else {
            Debug.warn("Failed to create temporary directory {0}", tempDirectory);
            tempDirectory = null;
        }
        sessionDirectory = new File(baseDir, String.valueOf(appName) + "session");
        if (sessionDirectory.isDirectory() || sessionDirectory.mkdir()) {
            TempFileManager.addSessionFile(sessionDirectory);
            sessionDirectory.deleteOnExit();
        } else {
            Debug.warn("Failed to create temporary directory {0}", sessionDirectory);
            sessionDirectory = null;
        }
    }

    private static File newTempFile(File where, String prefix, String suffix) throws IOException {
        if (where == null) {
            return File.createTempFile(prefix, suffix);
        }
        return File.createTempFile(prefix, suffix, where);
    }

    public static synchronized File createTempFile(String prefix, String suffix) throws IOException {
        File file = TempFileManager.newTempFile(tempDirectory, prefix, suffix);
        file.deleteOnExit();
        if (tempDirectory == null) {
            TempFileManager.addTempFile(file);
        }
        return file;
    }

    public static synchronized boolean deleteTempFile(File file) {
        boolean result = file.delete();
        if (result && tempDirectory == null) {
            TempFileManager.removeTempFile(file);
        }
        return result;
    }

    public static synchronized File createSessionFile(String prefix, String suffix) throws IOException {
        File file = TempFileManager.newTempFile(sessionDirectory, prefix, suffix);
        if (sessionDirectory == null) {
            TempFileManager.addSessionFile(file);
        }
        return file;
    }

    public static synchronized boolean deleteSessionFile(File file) {
        boolean result = file.delete();
        if (result && sessionDirectory == null) {
            TempFileManager.removeSessionFile(file);
        }
        return result;
    }

    private static synchronized void addTempFile(File file) {
        repository.getTemporaryFiles().add(file);
        TempFileManager.sync();
    }

    private static synchronized void removeTempFile(File file) {
        repository.getTemporaryFiles().remove(file);
        TempFileManager.sync();
    }

    private static synchronized Collection<File> getTempFiles() {
        return repository.getTemporaryFiles();
    }

    private static synchronized void addSessionFile(File file) {
        repository.getSessionFiles().add(file);
        TempFileManager.sync();
    }

    private static synchronized void removeSessionFile(File file) {
        repository.getSessionFiles().remove(file);
        TempFileManager.sync();
    }

    public static synchronized Collection<File> getSessionFiles() {
        return repository.getSessionFiles();
    }
}

