/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.math;

import java.io.Serializable;
import java.util.Random;
import org.corebounce.common.math.FractionConst;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fraction
extends Number
implements Cloneable,
Comparable<Fraction>,
Serializable {
    private static final long serialVersionUID = 7176748729824878744L;
    public static final Fraction ZERO = new FractionConst(0L, 1L);
    public static final Fraction ONE = new FractionConst(1L, 1L);
    private long base;
    private long num;
    private long denom;

    public Fraction(long num, long denom) {
        this.base = num / denom;
        this.num = num % denom;
        this.denom = denom;
        this.reduce();
    }

    public Fraction(long base, long num, long denom) {
        this.base = base;
        this.num = num;
        this.denom = denom;
        this.reduce();
    }

    public Fraction() {
        this(1L, 1L);
    }

    public Fraction(long value) {
        this.base = value;
        this.num = 0L;
        this.denom = 1L;
    }

    public Fraction(Fraction value) {
        this.base = value.base;
        this.num = value.num;
        this.denom = value.denom;
    }

    public void set(long num, long denom) {
        this.base = num / denom;
        this.num = num % denom;
        this.denom = denom;
        this.reduce();
    }

    public void set(long base, long num, long denom) {
        this.base = base;
        this.num = num;
        this.denom = denom;
        this.reduce();
    }

    public void set(long value) {
        this.base = value;
        this.num = 0L;
        this.denom = 1L;
    }

    public void set(Fraction value) {
        this.base = value.base;
        this.num = value.num;
        this.denom = value.denom;
    }

    public long getBase() {
        return this.base;
    }

    public long getNum() {
        return this.num;
    }

    public long getDenom() {
        return this.denom;
    }

    public long getExtNum() {
        return this.base * this.denom + this.num;
    }

    public float getNumByDenom() {
        return (float)this.num / (float)this.denom;
    }

    /*
     * Unable to fully structure code
     */
    public static long gcd(long a, long b) {
        if (a != 0L && b != 0L) ** GOTO lbl6
        return 1L;
lbl-1000:
        // 1 sources

        {
            t = b;
            b = a % b;
            a = t;
lbl6:
            // 2 sources

            ** while (b != 0L)
        }
lbl7:
        // 1 sources

        return a;
    }

    private void reduce() {
        long gdc;
        if (this.num == 0L) {
            this.denom = 1L;
            return;
        }
        if (this.num == this.denom) {
            ++this.base;
            this.num = 0L;
            this.denom = 1L;
            return;
        }
        if (this.denom == 1L) {
            this.base += this.num;
            this.num = 0L;
            return;
        }
        if (this.denom < 0L) {
            this.num = -this.num;
            this.denom = -this.denom;
        }
        if (this.num < 0L) {
            this.base -= -this.num / this.denom + 1L;
            this.num = -(-this.num % this.denom) + this.denom;
        }
        if ((gdc = Fraction.gcd(this.num, this.denom)) != 1L) {
            this.num /= gdc;
            this.denom /= gdc;
        }
        this.basify();
    }

    private void basify() {
        if (this.num >= this.denom) {
            this.base += this.num / this.denom;
            this.num %= this.denom;
        }
    }

    private void normalize() {
        if (this.num < 0L) {
            this.base -= -this.num / this.denom + 1L;
            this.num = -(-this.num % this.denom) + this.denom;
        }
        this.basify();
    }

    public boolean boundTo(int numberOfBits) {
        long ceil = 1L << numberOfBits;
        if (this.denom < ceil) {
            return false;
        }
        this.fromDouble(this.doubleValue(), numberOfBits);
        return true;
    }

    public boolean isSafe() {
        long SAFE_MAX = 0x15555555L;
        if (this.num > 0x15555555L) {
            return false;
        }
        if (this.denom > 0x15555555L) {
            return false;
        }
        return Math.abs(this.base) <= 0x15555555L;
    }

    public Fraction add(Fraction other) {
        this.base += other.base;
        this.num = this.num * other.denom + other.num * this.denom;
        this.denom *= other.denom;
        this.reduce();
        return this;
    }

    public static Fraction sum(Fraction v1, Fraction v2) {
        return new Fraction(v1).add(v2);
    }

    public Fraction add(long value) {
        this.base += value;
        return this;
    }

    public Fraction sub(Fraction other) {
        this.base -= other.base;
        this.num = this.num * other.denom - other.num * this.denom;
        this.denom *= other.denom;
        this.reduce();
        return this;
    }

    public static Fraction diff(Fraction v1, Fraction v2) {
        return new Fraction(v1).sub(v2);
    }

    public Fraction sub(long value) {
        this.base -= value;
        return this;
    }

    public Fraction mul(Fraction other) {
        if (other.num == 0L) {
            this.mul(other.base);
            return this;
        }
        long thisBase = this.base;
        long thisNum = this.num;
        long thisDenom = this.denom;
        this.base = thisBase * other.base + thisBase * other.num / other.denom + other.base * thisNum / thisDenom;
        this.num = this.num * other.num + thisBase * other.num % other.denom * thisDenom + other.base * thisNum % thisDenom * other.denom;
        this.denom = thisDenom * other.denom;
        this.reduce();
        return this;
    }

    public Fraction mulFast(Fraction other) {
        this.num = (this.num + this.base * this.denom) * (other.num + other.base * other.denom);
        this.denom *= other.denom;
        this.base = 0L;
        this.reduce();
        return this;
    }

    public static Fraction prod(Fraction v1, Fraction v2) {
        return new Fraction(v1).mul(v2);
    }

    public Fraction mul(long value) {
        this.base *= value;
        this.num *= value;
        this.normalize();
        return this;
    }

    public Fraction div(Fraction other) {
        long otherNum = other.num + other.base * other.denom;
        long otherDenom = other.denom;
        long thisBase = this.base;
        long thisNum = this.num;
        long thisDenom = this.denom;
        this.base = thisBase * otherDenom / otherNum;
        this.num = thisBase * otherDenom % otherNum * thisDenom + thisNum * otherDenom;
        this.denom = thisDenom * otherNum;
        this.reduce();
        return this;
    }

    public static Fraction quo(Fraction v1, Fraction v2) {
        return new Fraction(v1).div(v2);
    }

    public Fraction div(long value) {
        this.num += this.base % value * this.denom;
        this.base /= value;
        this.denom *= value;
        this.reduce();
        return this;
    }

    public Fraction inverse() {
        this.num += this.base * this.denom;
        this.base = 0L;
        this.num ^= this.denom;
        this.denom = this.num ^ this.denom;
        this.num ^= this.denom;
        this.normalize();
        return this;
    }

    public static Fraction inverse(Fraction v) {
        return new Fraction(v).inverse();
    }

    public boolean isOne() {
        return this.base == 1L && this.num == 0L;
    }

    public boolean isZero() {
        return this.base == 0L && this.num == 0L;
    }

    public boolean isInteger() {
        return this.num == 0L;
    }

    public boolean isNegative() {
        return this.base < 0L;
    }

    public boolean isStrictlyPositive() {
        return this.base > 0L || this.base == 0L && this.num > 0L;
    }

    @Override
    public double doubleValue() {
        return (double)this.base + (double)this.num / (double)this.denom;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    public static Fraction fromFloat(float value) {
        return new Fraction().fromDouble(value, 20);
    }

    public static Fraction fromDouble(double value) {
        return new Fraction().fromDouble(value, 32);
    }

    public Fraction fromDouble(double value, int bitPrecision) {
        assert (bitPrecision > 0 && bitPrecision < 64) : "bitPrecision must be within 1..63";
        double sky = value;
        if (sky < 0.0) {
            sky = -sky;
        }
        double ground = 1.0;
        double epsilon = 1.0 / (double)(1L << bitPrecision);
        while (ground >= epsilon) {
            if (sky > ground) {
                double swap = sky;
                sky = ground;
                ground = swap;
            }
            ground -= Math.floor(ground / sky) * sky;
        }
        this.num = (long)(value / sky + (value < 0.0 ? -0.5 : 0.5));
        this.denom = (long)(1.0 / sky + 0.5);
        this.base = this.num / this.denom;
        this.num %= this.denom;
        this.reduce();
        return this;
    }

    public long round() {
        return this.num * 2L > this.denom ? this.base + 1L : this.base;
    }

    public long floor() {
        return this.base;
    }

    public long ceil() {
        return this.num == 0L ? this.base : this.base + 1L;
    }

    @Override
    public int intValue() {
        return (int)this.round();
    }

    @Override
    public long longValue() {
        return this.round();
    }

    public Fraction seal() {
        return new FractionConst(this);
    }

    @Override
    public int compareTo(Fraction other) {
        if (this.base < other.base) {
            return -1;
        }
        if (this.base > other.base) {
            return 1;
        }
        long t1 = this.num * other.denom;
        long t2 = other.num * this.denom;
        if (t1 < t2) {
            return -1;
        }
        if (t1 > t2) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(long value) {
        if (this.base < value) {
            return -1;
        }
        if (this.base > value) {
            return 1;
        }
        long norm = value * this.denom;
        if (this.num < norm) {
            return -1;
        }
        if (this.num > norm) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return String.valueOf(this.base) + "+(" + this.num + "/" + this.denom + ")";
    }

    public boolean equals(long num, long denom) {
        long c;
        if (this.base != num / denom) {
            return false;
        }
        return (num %= denom) / (c = Fraction.gcd(num, denom)) == this.num && denom / c == this.denom;
    }

    public boolean equals(long value) {
        return this.base == value && this.num == 0L;
    }

    public boolean equals(Object o) {
        if (o instanceof Fraction) {
            Fraction other = (Fraction)o;
            return this.base == other.base && this.num == other.num && this.denom == other.denom;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.base >>> 32) ^ (int)(this.base & 0xFFFFFFFFFFFFFFFFL) ^ (int)(this.num >>> 32) ^ (int)(this.num & 0xFFFFFFFFFFFFFFFFL) ^ (int)(this.denom >>> 32) ^ (int)(this.denom & 0xFFFFFFFFFFFFFFFFL);
    }

    public Fraction clone() {
        try {
            return (Fraction)super.clone();
        }
        catch (CloneNotSupportedException cannotHappen) {
            throw new InternalError();
        }
    }

    public static void main(String ... args) {
        int i = 0;
        while (i < 1000) {
            Fraction.test();
            ++i;
        }
    }

    private static void test() throws InternalError {
        Random rnd = new Random();
        long seed = rnd.nextLong();
        System.out.println("Seed: " + seed);
        rnd.setSeed(seed);
        Fraction frac = new Fraction();
        String[] opNames = new String[]{"+", "-", "*", "/"};
        int i = 0;
        while (i < 30) {
            double chkFrac = frac.doubleValue();
            int op = rnd.nextInt(4);
            Fraction val = new Fraction(rnd.nextInt(20) - 9, rnd.nextInt(10) + 1);
            if (val.isZero()) {
                val = new Fraction(rnd.nextInt(10) + 1, rnd.nextInt(10) + 1);
            }
            double chkVal = val.doubleValue();
            System.out.print(frac + " " + opNames[op] + " " + val + " = ");
            switch (op) {
                case 0: {
                    frac.add(val);
                    chkFrac += chkVal;
                    break;
                }
                case 1: {
                    frac.sub(val);
                    chkFrac -= chkVal;
                    break;
                }
                case 2: {
                    frac.mul(val);
                    chkFrac *= chkVal;
                    break;
                }
                case 3: {
                    frac.div(val);
                    chkFrac /= chkVal;
                }
            }
            System.out.println(frac);
            if (frac.num < 0L || frac.denom < 1L || frac.num >= frac.denom) {
                throw new InternalError("Inconsistent fraction: " + frac);
            }
            double chkRes = frac.doubleValue();
            if ((float)chkRes != (float)chkFrac && (!frac.isZero() || Math.abs(chkFrac) > 1.0E-10)) {
                throw new InternalError(String.valueOf((float)chkRes) + "!=" + (float)chkFrac + ": " + frac);
            }
            if (!frac.isSafe()) {
                System.out.println("Fraction too complex. Reseting");
                frac = new Fraction();
            }
            ++i;
        }
    }
}

