/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.struct;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.corebounce.common.struct.CacheMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CacheReference<K, V>
extends SoftReference<V> {
    private final CacheMap<K, V> cacheMap;
    private final K key;

    public CacheReference(CacheMap<K, V> cacheMap, K key, V referent, ReferenceQueue<? super V> q) {
        super(referent, q);
        this.cacheMap = cacheMap;
        this.key = key;
    }

    public K getKey() {
        return this.key;
    }

    void dispose() {
        this.cacheMap.remove(this.getKey());
    }

    CacheMap<K, V> getCacheMap() {
        return this.cacheMap;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CacheReference) {
            CacheReference other = (CacheReference)obj;
            Object otherItem = other.get();
            Object thisItem = this.get();
            if (otherItem == null) {
                return thisItem == null;
            }
            return otherItem.equals(thisItem);
        }
        return false;
    }

    public int hashCode() {
        Object item = this.get();
        if (item == null) {
            return 0;
        }
        return item.hashCode();
    }

    public String toString() {
        return "" + this.get();
    }
}

