/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.thread;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.corebounce.common.thread.Task;

public class ThreadPool {
    private static final int QUEUE_SIZE = 200;
    private static ThreadPool instance = null;
    private final int poolSize;
    private final BlockingQueue<Task> taskQueue;
    private final Thread[] poolThreads;
    private volatile boolean active = true;

    private ThreadPool() {
        int nbCores = Runtime.getRuntime().availableProcessors();
        this.poolSize = nbCores > 1 ? nbCores : 0;
        this.taskQueue = new ArrayBlockingQueue<Task>(200, false);
        this.poolThreads = new Thread[this.poolSize];
        int i = 0;
        while (i < this.poolSize) {
            PoolThread t = new PoolThread();
            this.poolThreads[i] = t;
            t.setName("PoolThread-" + i);
            t.start();
            ++i;
        }
    }

    private static synchronized ThreadPool instance() {
        if (instance == null) {
            instance = new ThreadPool();
        }
        return instance;
    }

    private void processTask(boolean wait) {
        Task task = null;
        if (wait) {
            try {
                task = this.taskQueue.take();
            }
            catch (InterruptedException ex) {
                if (!this.active) {
                    return;
                }
                ex.printStackTrace();
            }
        } else {
            task = (Task)this.taskQueue.poll();
        }
        if (task == null) {
            return;
        }
        try {
            task.run();
        }
        finally {
            task.setTerminated();
        }
    }

    protected void execute(Task task) {
        boolean nested = Thread.currentThread() instanceof PoolThread;
        if (nested) {
            while (!this.taskQueue.offer(task)) {
                this.processTask(false);
            }
        } else {
            try {
                this.taskQueue.put(task);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void waitFor(CountDownLatch latch) {
        boolean nested = Thread.currentThread() instanceof PoolThread;
        try {
            if (nested) {
                while (!latch.await(0L, TimeUnit.NANOSECONDS)) {
                    this.processTask(false);
                }
            } else {
                latch.await();
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    protected void executeAndWait0(Task ... tasks) {
        if (this.poolSize <= 1) {
            Task[] taskArray = tasks;
            int n = tasks.length;
            int n2 = 0;
            while (n2 < n) {
                Task task = taskArray[n2];
                task.run();
                ++n2;
            }
        } else {
            CountDownLatch latch = new CountDownLatch(tasks.length);
            Task[] taskArray = tasks;
            int n = tasks.length;
            int n3 = 0;
            while (n3 < n) {
                Task task = taskArray[n3];
                task.setLatch(latch);
                this.execute(task);
                ++n3;
            }
            this.waitFor(latch);
        }
    }

    public static void executeAndWait(Task ... tasks) {
        ThreadPool.instance().executeAndWait0(tasks);
    }

    private void dispose0() {
        this.active = false;
        Thread[] threadArray = this.poolThreads;
        int n = this.poolThreads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread t = threadArray[n2];
            t.interrupt();
            try {
                t.join(3000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
    }

    public static void dispose() {
        ThreadPool.instance().dispose0();
    }

    private class PoolThread
    extends Thread {
        private PoolThread() {
        }

        public void run() {
            while (ThreadPool.this.active) {
                ThreadPool.this.processTask(true);
            }
        }
    }
}

