/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.utils;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppUtils {
    private static String appName;

    public static void setAppName(String appName) {
        AppUtils.appName = appName;
    }

    public static String getAppName() {
        return appName == null ? "" : appName;
    }

    public static File getApplicationDirectory(Class<?> mainClass) {
        String ourJar;
        File file;
        String classPaths = System.getProperty("java.class.path");
        String[] cpArr = classPaths.split("\\" + File.pathSeparator);
        if (cpArr != null && cpArr.length == 1 && (file = new File(ourJar = cpArr[0])).exists() && file.isFile()) {
            return file.getAbsoluteFile().getParentFile();
        }
        if (cpArr != null && cpArr.length >= 1) {
            String className = mainClass.getName();
            String fileName = String.valueOf(className.replace('.', '/')) + ".class";
            String[] stringArray = cpArr;
            int n = cpArr.length;
            int n2 = 0;
            while (n2 < n) {
                String classPath = stringArray[n2];
                File path = new File(classPath);
                if (path.isDirectory()) {
                    File classFile = new File(path, fileName);
                    if (classFile.exists() && classFile.isFile()) {
                        return path.getAbsoluteFile();
                    }
                } else if (path.isFile() && path.getName().endsWith(".jar")) {
                    try {
                        JarFile jarFile = new JarFile(path);
                        ZipEntry entry = jarFile.getEntry(fileName);
                        if (entry != null) {
                            return path.getAbsoluteFile().getParentFile();
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        return new File(System.getProperty("user.dir"));
    }

    public static void searchAndCleanTheCrapOfJSmooth() {
        File jsmoothJar;
        String PREFS_KEY = "jsmooth.file";
        Preferences prefs = Preferences.userNodeForPackage(AppUtils.class);
        String previousFile = prefs.get("jsmooth.file", null);
        if (previousFile != null) {
            File file = new File(previousFile);
            file.delete();
        }
        if ((jsmoothJar = AppUtils.findJSmoothJarFile()) != null) {
            prefs.put("jsmooth.file", jsmoothJar.getAbsolutePath());
        }
    }

    private static File findJSmoothJarFile() {
        String jsmoothTestClass = "jsmooth.Native";
        String fileName = String.valueOf("jsmooth.Native".replace('.', '/')) + ".class";
        String classPaths = System.getProperty("java.class.path");
        String[] cpArr = classPaths.split("\\" + File.pathSeparator);
        if (cpArr != null && cpArr.length > 0) {
            String[] stringArray = cpArr;
            int n = cpArr.length;
            int n2 = 0;
            while (n2 < n) {
                String classPath = stringArray[n2];
                File path = new File(classPath);
                if (path.isFile() && path.getName().endsWith(".jar")) {
                    try {
                        JarFile jarFile = new JarFile(path);
                        ZipEntry entry = jarFile.getEntry(fileName);
                        if (entry != null) {
                            return path.getAbsoluteFile();
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        return null;
    }
}

