/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.corebounce.common.math.Fraction;
import org.corebounce.decklight.BounceletBase;
import org.corebounce.decklight.BounceletGraph;
import org.corebounce.decklight.BounceletPriority;
import org.corebounce.decklight.FlowEngine;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.Port;
import org.corebounce.decklight.Scheduler;
import org.corebounce.decklight.macro.Connector;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;
import org.corebounce.decklight.ports.PublicCloneable;
import org.corebounce.decklight.ports.StructOutputPort;
import org.corebounce.utils.ClassInfo;
import org.corebounce.utils.Log;
import org.corebounce.utils.MemberInfo;
import org.corebounce.utils.Severity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Bouncelet
extends BounceletBase {
    public static final int UNDEFINED_DURATION = -1;
    private long curTime = 0L;
    private Fraction inpRate = null;
    private boolean isLatencyDirty = true;
    private int minInLatency = -1;
    private int maxInLatency = -1;
    private List<InputPort<?>> inputPorts;
    private List<OutputPort<?>> outputPorts;
    private Map<String, Port<?>> ports;
    BounceletGraph graph = null;
    Scheduler scheduler = null;

    protected Bouncelet(String name, String description, boolean isTarget) {
        super(name, description, isTarget);
    }

    protected Bouncelet(String name, String description) {
        this(name, description, false);
    }

    public final Bouncelet[] getParts() {
        return new Bouncelet[]{this};
    }

    @Override
    public final void createInternalConnections(Connector connector) {
    }

    public void init() {
    }

    public void dispose() {
    }

    public final long getTime() {
        return this.curTime;
    }

    void setTime(long time) {
        this.curTime = time;
    }

    void resetTime() {
        this.curTime = -1L;
    }

    void resetLatency() {
        if (this.isSource()) {
            this.minInLatency = 0;
            this.maxInLatency = 0;
            this.isLatencyDirty = false;
        } else {
            this.minInLatency = -1;
            this.maxInLatency = -1;
            this.isLatencyDirty = true;
        }
    }

    void setMinInLatency(int latency) {
        this.minInLatency = latency;
    }

    int getMinInLatency() {
        return this.minInLatency;
    }

    void setMaxInLatency(int latency) {
        this.maxInLatency = latency;
    }

    int getMaxInLatency() {
        return this.maxInLatency;
    }

    boolean isLatencyDirty() {
        return this.isLatencyDirty;
    }

    void latencyUpdated() {
        this.isLatencyDirty = this.minInLatency != -1 && this.maxInLatency != -1;
    }

    public int getFullMinLatency() {
        return this.minInLatency + this.getLatency();
    }

    public int getFullMaxLatency() {
        return this.maxInLatency + this.getLatency();
    }

    void setInpRate(Fraction rate) {
        Fraction rtRate = this.cycleSpeed();
        if (rtRate != null && !rtRate.equals(rate)) {
            throw new IllegalArgumentException("Real-time rate " + rtRate + " != rate " + rate);
        }
        if (rate != null) {
            if (this.inpRate == null) {
                this.inpRate = new Fraction();
            }
            this.inpRate.set(rate);
        }
    }

    protected boolean isInpRateKnown() {
        return this.inpRate != null;
    }

    protected Fraction getInpRate() {
        Fraction result = this.cycleSpeed();
        if (result != null) {
            return result;
        }
        if (this.inpRate != null) {
            return this.inpRate;
        }
        return null;
    }

    protected void reset() {
        this.inpRate = null;
    }

    public BounceletPriority getPriority() {
        return BounceletPriority.REGULAR;
    }

    public boolean isSource() {
        return false;
    }

    public boolean isSink() {
        return false;
    }

    public Fraction cycleSpeed() {
        return null;
    }

    public Fraction timeSkew() {
        return Fraction.ONE;
    }

    public int getLatency() {
        return 0;
    }

    public boolean isClocking() {
        return false;
    }

    public final boolean isRealtime() {
        return this.cycleSpeed() != null;
    }

    protected void ensureInput(InputPort<?> inputPort, FlowEngine engine) {
        if (inputPort.isConnected()) {
            engine.requestData(inputPort);
        }
    }

    public void fullCycle(FlowEngine engine) {
        for (InputPort<?> inputPort : this.getInputPorts()) {
            this.ensureInput(inputPort, engine);
        }
        this.cycle();
    }

    public abstract void cycle();

    public <E> void scheduleSetPortValue(InputPort<E> port, E value) {
        this.graph.scheduleSetPortValue(port, value);
    }

    protected <E> void transfer(InputPort<E> srcPort, OutputPort<E> dstPort) {
        Port.transfer(srcPort, dstPort);
    }

    protected <E extends PublicCloneable<E>> void copyInPlace(InputPort<E> srcPort, StructOutputPort<E> dstPort) {
        if (!srcPort.canProcessInPlace()) {
            throw new IllegalStateException("Input port cannot perform in place: " + srcPort);
        }
        dstPort.set((PublicCloneable)srcPort.read());
    }

    protected final void log(GraphErrorType type, Severity severity, String message, Object ... args) {
        if (this.graph != null) {
            this.graph.logMessage(type, severity, this, Log.format(message, args), new Object[0]);
        } else {
            Log.message(1, severity, message, args);
        }
    }

    private void initializePorts() {
        this.inputPorts = new ArrayList();
        this.outputPorts = new ArrayList();
        this.ports = new HashMap();
        ClassInfo info = new ClassInfo(this.getClass());
        for (MemberInfo member : info.getMembers()) {
            String name;
            Port port;
            if (InputPort.class.isAssignableFrom(member.getType())) {
                try {
                    port = (InputPort)member.getValue(this);
                    this.inputPorts.add((InputPort<?>)port);
                    name = port.getName();
                    if (this.ports.containsKey(name)) {
                        throw new IllegalStateException("Duplicate port name: " + name + " in Bouncelet " + this.getClass());
                    }
                    this.ports.put(name, port);
                    port.setOwner(this);
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                }
            }
            if (!OutputPort.class.isAssignableFrom(member.getType())) continue;
            try {
                port = (OutputPort)member.getValue(this);
                this.outputPorts.add((OutputPort<?>)port);
                name = port.getName();
                if (this.ports.containsKey(name)) {
                    throw new IllegalStateException("Duplicate port name: " + name + " in Bouncelet " + this.getClass());
                }
                this.ports.put(name, port);
                port.setOwner(this);
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
        }
        this.inputPorts = Collections.unmodifiableList(this.inputPorts);
        this.outputPorts = Collections.unmodifiableList(this.outputPorts);
        this.ports = Collections.unmodifiableMap(this.ports);
    }

    @Override
    public List<InputPort<?>> getInputPorts() {
        if (this.inputPorts == null) {
            this.initializePorts();
        }
        return this.inputPorts;
    }

    @Override
    public List<OutputPort<?>> getOutputPorts() {
        if (this.outputPorts == null) {
            this.initializePorts();
        }
        return this.outputPorts;
    }
}

