/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.BounceletBase;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.GraphListener;
import org.corebounce.decklight.Scheduler;
import org.corebounce.decklight.Transaction;
import org.corebounce.decklight.macro.Connector;
import org.corebounce.decklight.play.PlayState;
import org.corebounce.decklight.play.PlayStateChangeListener;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;
import org.corebounce.utils.Log;
import org.corebounce.utils.LowThreadFactory;
import org.corebounce.utils.Severity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BounceletGraph
implements Connector,
Cloneable {
    private final boolean manual;
    private Set<Bouncelet> bouncelets = new HashSet<Bouncelet>();
    private Set<Bouncelet> targets = new LinkedHashSet<Bouncelet>();
    private Map<InputPort<?>, OutputPort<?>> connections = new HashMap();
    private Map<Bouncelet, Map<InputPort<?>, OutputPort<?>>> outputConnections = new HashMap();
    private Map<Bouncelet, Map<InputPort<?>, OutputPort<?>>> inputConnections = new HashMap();
    private final Scheduler scheduler = new Scheduler(this, "Audio");
    private Set<GraphListener> graphListeners = new LinkedHashSet<GraphListener>();
    private Set<PlayStateChangeListener> playStateListeners = new LinkedHashSet<PlayStateChangeListener>();

    public BounceletGraph() {
        this(false);
    }

    public BounceletGraph(boolean manual) {
        this.manual = manual;
        if (!manual) {
            this.scheduler.start();
            this.scheduler.setOverrunDetectionEnabled(true);
            LowThreadFactory.getInstance();
        }
    }

    public boolean addBouncelet(Bouncelet b) {
        if (this.bouncelets.contains(b)) {
            this.logMessage(GraphErrorType.ClientServerError, Severity.Error, b, "Bouncelet already present: {0}", b);
            return false;
        }
        assert (b.graph == null);
        b.graph = this;
        b.init();
        this.bouncelets.add(b);
        this.outputConnections.put(b, new HashMap());
        this.inputConnections.put(b, new HashMap());
        b.resetTime();
        if (b.isTarget()) {
            this.targets.add(b);
        }
        for (InputPort<?> port : b.getInputPorts()) {
            if (port.isConnected()) continue;
            port.sourceChanged();
        }
        this.scheduler.addBouncelet(b);
        if (this.isSinking(b)) {
            this.scheduler.planReschedule();
        }
        return true;
    }

    public <E> boolean addConnection(OutputPort<? extends E> srcPort, InputPort<E> dstPort) {
        InputPort<?> speedModifier;
        Bouncelet srcBouncelet = srcPort.getBouncelet();
        Bouncelet dstBouncelet = dstPort.getBouncelet();
        if (srcBouncelet == null) {
            this.logMessage(GraphErrorType.ClientServerError, Severity.Error, this, "Attempting to connect from a port whose bouncelet has not been added. Output port name: {0}", srcPort);
            return false;
        }
        if (!this.bouncelets.contains(srcBouncelet)) {
            this.logMessage(GraphErrorType.ClientServerError, Severity.Error, this, "Unknown source bouncelet {0}", srcBouncelet);
            return false;
        }
        if (dstBouncelet == null) {
            this.logMessage(GraphErrorType.ClientServerError, Severity.Error, this, "Attempting to connect to a port whose bouncelet has not been added. Input port name: {0}", dstPort);
            return false;
        }
        if (!this.bouncelets.contains(dstBouncelet)) {
            this.logMessage(GraphErrorType.ClientServerError, Severity.Error, this, "Unknown target bouncelet {0}", dstBouncelet);
            return false;
        }
        if (this.inputConnections.get(dstBouncelet).containsValue(dstPort)) {
            this.logMessage(GraphErrorType.ClientServerError, Severity.Error, dstPort, "Port already connected: {0}", dstPort);
            return false;
        }
        Bouncelet source = this.getFirstSourceUpwards(srcBouncelet);
        if (source != null && (speedModifier = this.getFirstSpeedModifierDownwards(srcBouncelet)) != null) {
            this.logMessage(GraphErrorType.IllegalArgument, Severity.Warning, dstPort, "The value of port {0} can affect the flow speed.\nIt is strongly discouraged to link this port to source {1}.", speedModifier, source);
        }
        if (!dstPort.getDataType().isAssignableFrom(srcPort.getDataType())) {
            this.logMessage(GraphErrorType.ClientServerError, Severity.Error, this, "Cannot connect {0} to {1}. Datatypes {2} not compatible with {3}", srcPort, dstPort, srcPort.getDataType(), dstPort.getDataType());
            return false;
        }
        this.connections.put(dstPort, srcPort);
        this.inputConnections.get(dstBouncelet).put(dstPort, srcPort);
        this.outputConnections.get(srcBouncelet).put(dstPort, srcPort);
        dstPort.connect(srcPort);
        if (this.isSinking(dstBouncelet)) {
            srcBouncelet.scheduler.planReschedule();
            if (dstBouncelet.scheduler != srcBouncelet.scheduler) {
                dstBouncelet.scheduler.planReschedule();
            }
        }
        return true;
    }

    public boolean addConnection(BounceletBase srcBouncelet, String srcPortName, BounceletBase dstBouncelet, String dstPortName) {
        OutputPort<?> srcPort = null;
        for (OutputPort<?> port : srcBouncelet.getOutputPorts()) {
            if (!port.getName().equals(srcPortName)) continue;
            srcPort = port;
        }
        if (srcPort == null) {
            this.logMessage(GraphErrorType.ClientServerError, Severity.Error, this, "Unknown output port: {0}", srcPortName);
            return false;
        }
        InputPort<?> dstPort = null;
        for (InputPort<?> port : dstBouncelet.getInputPorts()) {
            if (!port.getName().equals(dstPortName)) continue;
            dstPort = port;
        }
        if (dstPort == null) {
            this.logMessage(GraphErrorType.ClientServerError, Severity.Error, this, "Unknown output port: {0}", srcPortName);
            return false;
        }
        return this.addConnection(srcPort, dstPort);
    }

    @Override
    public <E> void connect(OutputPort<? extends E> srcPort, InputPort<E> dstPort) {
        boolean success = this.addConnection(srcPort, dstPort);
        if (!success) {
            this.logMessage(GraphErrorType.ServerError, Severity.Catastroph, dstPort, "Invalid connection added by macro bouncelet: {0}->{1}", srcPort, dstPort);
        }
    }

    public boolean removeConnection(OutputPort<?> srcPort, InputPort<?> dstPort) {
        if (!srcPort.equals(this.connections.get(dstPort))) {
            this.logMessage(GraphErrorType.ClientServerError, Severity.Warning, this, "Unknown connection: {0}->{1}", srcPort, dstPort);
            return false;
        }
        Bouncelet srcBouncelet = srcPort.getBouncelet();
        Bouncelet dstBouncelet = dstPort.getBouncelet();
        dstPort.connect(null);
        this.outputConnections.get(srcBouncelet).remove(dstPort);
        this.inputConnections.get(dstBouncelet).remove(dstPort);
        this.connections.remove(dstPort);
        srcBouncelet.scheduler.planClearTimingCaches();
        if (dstBouncelet.scheduler != srcBouncelet.scheduler) {
            dstBouncelet.scheduler.planClearTimingCaches();
        }
        return true;
    }

    public boolean removeBouncelet(Bouncelet b) {
        if (!this.bouncelets.contains(b)) {
            this.logMessage(GraphErrorType.ClientServerError, Severity.Warning, this, "Unknown bouncelet: {0}", b);
            return false;
        }
        Map<InputPort<?>, OutputPort<?>> incomming = this.inputConnections.get(b);
        for (InputPort<?> dstPort : new ArrayList(incomming.keySet())) {
            OutputPort<?> srcPort = incomming.get(dstPort);
            this.removeConnection(srcPort, dstPort);
        }
        assert (incomming.isEmpty());
        this.inputConnections.remove(b);
        Map<InputPort<?>, OutputPort<?>> outgoing = this.outputConnections.get(b);
        for (InputPort<?> dstPort : new ArrayList(outgoing.keySet())) {
            OutputPort<?> srcPort = outgoing.get(dstPort);
            this.removeConnection(srcPort, dstPort);
        }
        assert (outgoing.isEmpty());
        this.outputConnections.remove(b);
        if (b.isTarget()) {
            this.targets.remove(b);
        }
        this.bouncelets.remove(b);
        b.scheduler.removeBouncelet(b);
        b.dispose();
        b.graph = null;
        return true;
    }

    public void inputUpdated(InputPort<?> port) {
        Bouncelet b = port.getBouncelet();
        b.scheduler.inputUpdated(port);
        int portNum = b.getInputPorts().indexOf(port);
        for (GraphListener listener : this.graphListeners) {
            listener.portValueChanged(b.getId(), portNum, false, port.data);
        }
    }

    private Bouncelet getFirstSourceUpwards(Bouncelet bouncelet) {
        HashSet<Bouncelet> done = new HashSet<Bouncelet>();
        LinkedList<Bouncelet> todo = new LinkedList<Bouncelet>();
        todo.offer(bouncelet);
        while (!todo.isEmpty()) {
            Bouncelet b = (Bouncelet)todo.remove();
            done.add(b);
            if (b.isSource()) {
                return b;
            }
            for (InputPort<?> port : b.getInputPorts()) {
                Bouncelet src;
                if (!port.isConnected() || done.contains(src = port.getSource().getBouncelet())) continue;
                todo.offer(src);
            }
        }
        return null;
    }

    InputPort<?> getFirstSpeedModifierDownwards(Bouncelet bouncelet) {
        HashSet<Bouncelet> done = new HashSet<Bouncelet>();
        LinkedList<Bouncelet> todo = new LinkedList<Bouncelet>();
        todo.offer(bouncelet);
        while (!todo.isEmpty()) {
            Bouncelet b = (Bouncelet)todo.remove();
            done.add(b);
            for (InputPort<?> port : this.getOutputConnections(b).keySet()) {
                if (port.isSpeedModifier()) {
                    return port;
                }
                Bouncelet dst = port.getBouncelet();
                if (done.contains(dst)) continue;
                todo.offer(dst);
            }
        }
        return null;
    }

    boolean isSinking(Bouncelet bouncelet) {
        HashSet<Bouncelet> done = new HashSet<Bouncelet>();
        LinkedList<Bouncelet> todo = new LinkedList<Bouncelet>();
        todo.offer(bouncelet);
        while (!todo.isEmpty()) {
            Bouncelet b = (Bouncelet)todo.remove();
            done.add(b);
            if (b.isSink()) {
                return true;
            }
            for (InputPort<?> port : this.getOutputConnections(b).keySet()) {
                Bouncelet dst = port.getBouncelet();
                if (done.contains(dst)) continue;
                todo.offer(dst);
            }
        }
        return false;
    }

    boolean isCycling(Bouncelet bouncelet) {
        if (bouncelet.isTarget()) {
            return true;
        }
        HashSet<Bouncelet> done = new HashSet<Bouncelet>();
        LinkedList<Bouncelet> todo = new LinkedList<Bouncelet>();
        todo.offer(bouncelet);
        while (!todo.isEmpty()) {
            Bouncelet b = (Bouncelet)todo.remove();
            done.add(b);
            if (b.isTarget()) {
                return true;
            }
            for (InputPort<?> port : this.getOutputConnections(b).keySet()) {
                Bouncelet dst = port.getBouncelet();
                if (done.contains(dst)) continue;
                todo.offer(dst);
            }
        }
        return false;
    }

    public Bouncelet getBounceletById(int bounceletId) {
        for (Bouncelet b : this.bouncelets) {
            if (b.getId() != bounceletId) continue;
            return b;
        }
        return null;
    }

    public long getTime() {
        return this.scheduler.getTime();
    }

    public void setPlayState(PlayState playState, long when, Runnable callback) {
        this.scheduler.setPlayState(playState, when, callback);
    }

    public void reset() {
        this.scheduler.reset();
    }

    public void cycleManual() {
        this.scheduler.cycleManual();
    }

    public void enqueueTransaction(Transaction transaction) {
        if (transaction.getTime() <= (double)this.scheduler.getTime()) {
            this.executeTransaction(transaction);
        } else {
            this.scheduler.enqueueTransaction(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTransaction(final Transaction transaction) {
        if (this.manual) {
            transaction.commit();
        } else {
            Runnable audioBatch;
            Runnable runnable = audioBatch = new Runnable(){

                public void run() {
                    transaction.commit();
                }
            };
            synchronized (runnable) {
                this.scheduler.enqueueImmediateCommand(audioBatch);
            }
        }
    }

    Map<InputPort<?>, OutputPort<?>> getOutputConnections(Bouncelet b) {
        return this.outputConnections.get(b);
    }

    public void dispose() {
        Log.info("Bouncelet Graph terminating...", new Object[0]);
        this.scheduler.finish();
        try {
            if (this.scheduler.isAlive()) {
                this.scheduler.join();
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        for (Bouncelet b : new ArrayList<Bouncelet>(this.bouncelets)) {
            this.removeBouncelet(b);
        }
        assert (this.bouncelets.isEmpty());
        assert (this.targets.isEmpty());
        assert (this.connections.isEmpty());
        assert (this.inputConnections.isEmpty());
        assert (this.outputConnections.isEmpty());
        this.logMessage(GraphErrorType.Information, Severity.Info, this, "Goodbye prof. Drake.", new Object[0]);
    }

    public void logMessage(GraphErrorType type, Severity severity, Object source, String message, Object ... args) {
        Log.message(1, severity, message, args);
        message = Log.format(message, args);
        for (GraphListener listener : this.graphListeners) {
            listener.logMessage(type, severity, message, source);
        }
    }

    <E> void scheduleSetPortValue(final InputPort<E> port, final E value) {
        if (port.isConnected()) {
            throw new IllegalStateException("The port is connected");
        }
        this.scheduler.enqueueImmediateCommand(new Runnable(){

            public void run() {
                port.write(value);
                BounceletGraph.this.inputUpdated(port);
            }
        });
    }

    public int addGraphListener(GraphListener listener) {
        this.graphListeners.add(listener);
        return this.graphListeners.size();
    }

    public void removeGraphListener(GraphListener listener) {
        this.graphListeners.remove(listener);
    }

    void stateChangedTo(PlayState state, long when) {
        for (PlayStateChangeListener listener : this.playStateListeners) {
            listener.playStateChanged(state, when);
        }
    }

    public void addPlayStateChangeListener(PlayStateChangeListener listener) {
        this.playStateListeners.add(listener);
    }

    public void removePlayStateChangeListener(PlayStateChangeListener listener) {
        this.playStateListeners.remove(listener);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public BounceletGraph clone() {
        try {
            HashMap resultConns;
            Map<InputPort<?>, OutputPort<?>> thisConns;
            BounceletGraph result = (BounceletGraph)super.clone();
            result.bouncelets = new HashSet<Bouncelet>(this.bouncelets);
            result.targets = new LinkedHashSet<Bouncelet>(this.targets);
            result.connections = new HashMap(this.connections);
            result.outputConnections = new HashMap();
            for (Bouncelet b : this.outputConnections.keySet()) {
                thisConns = this.outputConnections.get(b);
                resultConns = new HashMap(thisConns);
                result.outputConnections.put(b, resultConns);
            }
            for (Bouncelet b : this.inputConnections.keySet()) {
                thisConns = this.inputConnections.get(b);
                resultConns = new HashMap(thisConns);
                result.inputConnections.put(b, resultConns);
            }
            return result;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }
}

